/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _ISMBST_H
#define _ISMBST_H

#include <iasm.h>
#include <iicsm.h>
#include <iivsm.h>
#include <iismbst.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Element, class Key, class ElementOps>
class IGSortedMapAsBstTree;

template <class Element, class Key, class ElementOps>
class IGSortedMapAsBstTreeCursor :
  public IOrderedCursor <Element> {

  typedef  IOrderedCursor <Element> Inherited;

  typedef  IGSortedMapAsBstTree
            <Element, Key, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGSortedMapAsBstTreeCursor
                            (IGSortedMapAsBstTree
                              <
                               Element, Key, ElementOps> const&);

  IGSortedMapAsBstTreeCursor <Element, Key, ElementOps>&
           operator=        (IGSortedMapAsBstTreeCursor
                              <
                               Element, Key, ElementOps> const&);

protected:

           IGSortedMapAsBstTreeCursor
                            (ICursorImpl*);

private:


};

template <class Element, class Key, class ElementOps>
class IGSortedMapAsBstTree :
  public IASortedMap <Element, Key> {
protected:

  typedef  IGSortedMapAsBstTree <Element, Key, ElementOps> Self;

  typedef  ISortedMapAsBstTreeImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICSortedMapImpl
            <PureImplementation> Implementation;
#endif

#define IGSortedMapAsBstTreeTypedef(Element, Key, ElementOps)\
  typedef  ISortedMapAsBstTreeOps\
            <Element, Key,\
             IWEKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IGSortedMapAsBstTreeTypedef (Element, Key, ElementOps);

public:

  typedef  IGSortedMapAsBstTreeCursor
            <Element, Key, ElementOps> Cursor;


           IGSortedMapAsBstTree
                            (INumber = 100);

           IGSortedMapAsBstTree
                            (IGSortedMapAsBstTree
                              <
                               Element, Key, ElementOps> const&);

  IGSortedMapAsBstTree <Element, Key, ElementOps>&
           operator=        (IGSortedMapAsBstTree
                              <
                               Element, Key, ElementOps> const&);


protected:

           IGSortedMapAsBstTree
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGSortedMapAsBstTree
                              <
                               Element, Key, ElementOps> const&);

private:

  friend
  class    IGSortedMapAsBstTreeCursor
            <Element, Key, ElementOps>;



};

template <class Element, class Key>
class ISortedMapAsBstTree :
  public IGSortedMapAsBstTree
          <Element, Key, IEKCOps <Element, Key> > {

  typedef  IGSortedMapAsBstTree
            <Element, Key,
             IEKCOps <Element, Key> > Inherited;

protected:

  typedef  ISortedMapAsBstTree <Element, Key> Self;

#define ISortedMapAsBstTreeTypedef(Element, Key)\
  typedef  ISortedMapAsBstTreeOps\
            <Element, Key,\
             IWEKCOps <Element, Key, IEKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

           ISortedMapAsBstTree
                            (INumber = 100);


protected:

           ISortedMapAsBstTree
                              (PureImplementation&);

private:


};

template <class Element, class Key, class ElementOps>
class IVGSortedMapAsBstTree :
  public IGSortedMapAsBstTree
          <Element, Key, ElementOps > {

  typedef  IVGSortedMapAsBstTree
            <Element, Key, ElementOps> Inherited;

protected:

#if defined (INO_CHECKS)
  typedef  IVSortedMapImpl
            <PureImplementation> Implementation;
#else
  typedef  ICSortedMapImpl
            <IVSortedMapImpl
              <PureImplementation> > Implementation;
#endif

#define IVGSortedMapAsBstTreeTypedef(Element, Key, ElementOps)\
  typedef  ISortedMapAsBstTreeOps\
            <Element, Key,\
             IWEKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IVGSortedMapAsBstTreeTypedef (Element, Key, ElementOps);

public:

           IVGSortedMapAsBstTree
                            (INumber = 100);


protected:

           IVGSortedMapAsBstTree
                              (PureImplementation&);

private:


};

template <class Element, class Key>
class IVSortedMapAsBstTree :
  public IVGSortedMapAsBstTree
          <Element, Key, IEKCOps <Element, Key> > {

  typedef  IVGSortedMapAsBstTree
            <Element, Key,
             IEKCOps <Element, Key> > Inherited;

protected:

  typedef  IVSortedMapAsBstTree <Element, Key> Self;

#define IVSortedMapAsBstTreeTypedef(Element, Key)\
  typedef  IVSortedMapAsBstTreeOps\
            <Element, Key,\
             IWEKCOps <Element, Key, IEKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

           IVSortedMapAsBstTree
                            (INumber = 100);


protected:

           IVSortedMapAsBstTree
                              (PureImplementation&);

private:


};

#pragma SOMAsDefault (pop)

#include <ismbst.inl>

#pragma info (restore)
#pragma pack ()

#endif
