/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _ISMDIL_H
#define _ISMDIL_H

#include <iasm.h>
#include <iicsm.h>
#include <iivsm.h>
#include <iismdil.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Element, class Key, class ElementOps>
class IGSortedMapAsDilTable;

template <class Element, class Key, class ElementOps>
class IGSortedMapAsDilTableCursor :
  public IOrderedCursor <Element> {

  typedef  IOrderedCursor <Element> Inherited;

  typedef  IGSortedMapAsDilTable
            <Element, Key, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGSortedMapAsDilTableCursor
                            (IGSortedMapAsDilTable
                              <
                               Element, Key, ElementOps> const&);

  IGSortedMapAsDilTableCursor <Element, Key, ElementOps>&
           operator=        (IGSortedMapAsDilTableCursor
                              <
                               Element, Key, ElementOps> const&);

protected:

           IGSortedMapAsDilTableCursor
                            (ICursorImpl*);

private:


};

template <class Element, class Key, class ElementOps>
class IGSortedMapAsDilTable :
  public IASortedMap <Element, Key> {
protected:

  typedef  IGSortedMapAsDilTable <Element, Key, ElementOps> Self;

  typedef  ISortedMapAsDilTableImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICSortedMapImpl
            <PureImplementation> Implementation;
#endif

#define IGSortedMapAsDilTableTypedef(Element, Key, ElementOps)\
  typedef  ISortedMapAsDilTableOps\
            <Element, Key,\
             IWEKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IGSortedMapAsDilTableTypedef (Element, Key, ElementOps);

public:

  typedef  IGSortedMapAsDilTableCursor
            <Element, Key, ElementOps> Cursor;


           IGSortedMapAsDilTable
                            (INumber = 100);

           IGSortedMapAsDilTable
                            (IGSortedMapAsDilTable
                              <
                               Element, Key, ElementOps> const&);

  IGSortedMapAsDilTable <Element, Key, ElementOps>&
           operator=        (IGSortedMapAsDilTable
                              <
                               Element, Key, ElementOps> const&);


protected:

           IGSortedMapAsDilTable
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGSortedMapAsDilTable
                              <
                               Element, Key, ElementOps> const&);

private:

  friend
  class    IGSortedMapAsDilTableCursor
            <Element, Key, ElementOps>;



};

template <class Element, class Key>
class ISortedMapAsDilTable :
  public IGSortedMapAsDilTable
          <Element, Key, IEKCOps <Element, Key> > {

  typedef  IGSortedMapAsDilTable
            <Element, Key,
             IEKCOps <Element, Key> > Inherited;

protected:

  typedef  ISortedMapAsDilTable <Element, Key> Self;

#define ISortedMapAsDilTableTypedef(Element, Key)\
  typedef  ISortedMapAsDilTableOps\
            <Element, Key,\
             IWEKCOps <Element, Key, IEKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

           ISortedMapAsDilTable
                            (INumber = 100);


protected:

           ISortedMapAsDilTable
                              (PureImplementation&);

private:


};

template <class Element, class Key, class ElementOps>
class IVGSortedMapAsDilTable :
  public IGSortedMapAsDilTable
          <Element, Key, ElementOps > {

  typedef  IVGSortedMapAsDilTable
            <Element, Key, ElementOps> Inherited;

protected:

#if defined (INO_CHECKS)
  typedef  IVSortedMapImpl
            <PureImplementation> Implementation;
#else
  typedef  ICSortedMapImpl
            <IVSortedMapImpl
              <PureImplementation> > Implementation;
#endif

#define IVGSortedMapAsDilTableTypedef(Element, Key, ElementOps)\
  typedef  ISortedMapAsDilTableOps\
            <Element, Key,\
             IWEKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IVGSortedMapAsDilTableTypedef (Element, Key, ElementOps);

public:

           IVGSortedMapAsDilTable
                            (INumber = 100);


protected:

           IVGSortedMapAsDilTable
                              (PureImplementation&);

private:


};

template <class Element, class Key>
class IVSortedMapAsDilTable :
  public IVGSortedMapAsDilTable
          <Element, Key, IEKCOps <Element, Key> > {

  typedef  IVGSortedMapAsDilTable
            <Element, Key,
             IEKCOps <Element, Key> > Inherited;

protected:

  typedef  IVSortedMapAsDilTable <Element, Key> Self;

#define IVSortedMapAsDilTableTypedef(Element, Key)\
  typedef  IVSortedMapAsDilTableOps\
            <Element, Key,\
             IWEKCOps <Element, Key, IEKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

           IVSortedMapAsDilTable
                            (INumber = 100);


protected:

           IVSortedMapAsDilTable
                              (PureImplementation&);

private:


};

#pragma SOMAsDefault (pop)

#include <ismdil.inl>

#pragma info (restore)
#pragma pack ()

#endif
