/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

// ---
// IGSortedMapAsDilTableCursor
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IGSortedMapAsDilTableCursor <Element, Key, ElementOps>::
IGSortedMapAsDilTableCursor
  (IGSortedMapAsDilTable
    <Element, Key, ElementOps> const& collection)
: IOrderedCursor <Element>
    (collection.ivImpl->CreateCursor ())
{
}

template <class Element, class Key, class ElementOps>
inline IGSortedMapAsDilTableCursor <Element, Key, ElementOps>&
IGSortedMapAsDilTableCursor <Element, Key, ElementOps>::
operator=
  (IGSortedMapAsDilTableCursor
    <Element, Key, ElementOps> const& cursor)
{ Inherited::operator= (cursor);
  return *this;
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IGSortedMapAsDilTableCursor <Element, Key, ElementOps>::
IGSortedMapAsDilTableCursor (ICursorImpl* impl)
: IOrderedCursor <Element> (impl)
{
}

// ---
// IGSortedMapAsDilTable
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IGSortedMapAsDilTable <Element, Key, ElementOps>::
IGSortedMapAsDilTable (INumber numberOfElements)
{ SetImpl ((Implementation*) *new
                Instantiation (numberOfElements));
}

template <class Element, class Key, class ElementOps>
inline
IGSortedMapAsDilTable <Element, Key, ElementOps>::
IGSortedMapAsDilTable
  (IGSortedMapAsDilTable
    <Element, Key, ElementOps> const& collection)
{ CloneImplOf (collection);
}

template <class Element, class Key, class ElementOps>
inline IGSortedMapAsDilTable <Element, Key, ElementOps>&
IGSortedMapAsDilTable <Element, Key, ElementOps>::
operator= (IGSortedMapAsDilTable
            <Element, Key, ElementOps> const& collection)
{ ImplOf (*this).Copy (ImplOf (collection));
  return *this;
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IGSortedMapAsDilTable <Element, Key, ElementOps>::
IGSortedMapAsDilTable (PureImplementation& impl)
{ SetImpl (&impl);
}

template <class Element, class Key, class ElementOps>
inline IGSortedMapAsDilTable
 <Element, Key, ElementOps>::Implementation&
IGSortedMapAsDilTable <Element, Key, ElementOps>::
ImplOf (IGSortedMapAsDilTable
         <Element, Key, ElementOps> const& collection)
{ return *(Implementation*)collection.ivImpl;
}

// ---
// ISortedMapAsDilTable
// ---

// public members

template <class Element, class Key>
inline
ISortedMapAsDilTable <Element, Key>::
ISortedMapAsDilTable (INumber numberOfElements)
: IGSortedMapAsDilTable
   <Element, Key, IEKCOps <Element, Key> > (numberOfElements)
{
}

// protected members

template <class Element, class Key>
inline
ISortedMapAsDilTable <Element, Key>::
ISortedMapAsDilTable (PureImplementation& impl)
: IGSortedMapAsDilTable
   <Element, Key, IEKCOps <Element, Key> > (impl)
{
}

// ---
// IVGSortedMapAsDilTable
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IVGSortedMapAsDilTable <Element, Key, ElementOps>::
IVGSortedMapAsDilTable (INumber numberOfElements)
: IGSortedMapAsDilTable
    <Element, Key, ElementOps> (*(Implementation*) *new
                Instantiation (numberOfElements))
{
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IVGSortedMapAsDilTable <Element, Key, ElementOps>::
IVGSortedMapAsDilTable (PureImplementation& impl)
: IGSortedMapAsDilTable
    <Element, Key, ElementOps> (impl)
{
}

// ---
// IVSortedMapAsDilTable
// ---

// public members

template <class Element, class Key>
inline
IVSortedMapAsDilTable <Element, Key>::
IVSortedMapAsDilTable (INumber numberOfElements)
: IVGSortedMapAsDilTable
   <Element, Key, IEKCOps <Element, Key> > (numberOfElements)
{
}

// protected members

template <class Element, class Key>
inline
IVSortedMapAsDilTable <Element, Key>::
IVSortedMapAsDilTable (PureImplementation& impl)
: IVGSortedMapAsDilTable
   <Element, Key, IEKCOps <Element, Key> > (impl)
{
}
