/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

// ---
// IGSortedMapAsListCursor
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IGSortedMapAsListCursor <Element, Key, ElementOps>::
IGSortedMapAsListCursor
  (IGSortedMapAsList
    <Element, Key, ElementOps> const& collection)
: IOrderedCursor <Element>
    (collection.ivImpl->CreateCursor ())
{
}

template <class Element, class Key, class ElementOps>
inline IGSortedMapAsListCursor <Element, Key, ElementOps>&
IGSortedMapAsListCursor <Element, Key, ElementOps>::
operator=
  (IGSortedMapAsListCursor
    <Element, Key, ElementOps> const& cursor)
{ Inherited::operator= (cursor);
  return *this;
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IGSortedMapAsListCursor <Element, Key, ElementOps>::
IGSortedMapAsListCursor (ICursorImpl* impl)
: IOrderedCursor <Element> (impl)
{
}

// ---
// IGSortedMapAsList
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IGSortedMapAsList <Element, Key, ElementOps>::
IGSortedMapAsList (INumber numberOfElements)
{ SetImpl ((Implementation*) *new
                Instantiation (numberOfElements));
}

template <class Element, class Key, class ElementOps>
inline
IGSortedMapAsList <Element, Key, ElementOps>::
IGSortedMapAsList
  (IGSortedMapAsList
    <Element, Key, ElementOps> const& collection)
{ CloneImplOf (collection);
}

template <class Element, class Key, class ElementOps>
inline IGSortedMapAsList <Element, Key, ElementOps>&
IGSortedMapAsList <Element, Key, ElementOps>::
operator= (IGSortedMapAsList
            <Element, Key, ElementOps> const& collection)
{ ImplOf (*this).Copy (ImplOf (collection));
  return *this;
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IGSortedMapAsList <Element, Key, ElementOps>::
IGSortedMapAsList (PureImplementation& impl)
{ SetImpl (&impl);
}

template <class Element, class Key, class ElementOps>
inline IGSortedMapAsList
 <Element, Key, ElementOps>::Implementation&
IGSortedMapAsList <Element, Key, ElementOps>::
ImplOf (IGSortedMapAsList
         <Element, Key, ElementOps> const& collection)
{ return *(Implementation*)collection.ivImpl;
}

// ---
// ISortedMapAsList
// ---

// public members

template <class Element, class Key>
inline
ISortedMapAsList <Element, Key>::
ISortedMapAsList (INumber numberOfElements)
: IGSortedMapAsList
   <Element, Key, IEKCOps <Element, Key> > (numberOfElements)
{
}

// protected members

template <class Element, class Key>
inline
ISortedMapAsList <Element, Key>::
ISortedMapAsList (PureImplementation& impl)
: IGSortedMapAsList
   <Element, Key, IEKCOps <Element, Key> > (impl)
{
}

// ---
// IVGSortedMapAsList
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IVGSortedMapAsList <Element, Key, ElementOps>::
IVGSortedMapAsList (INumber numberOfElements)
: IGSortedMapAsList
    <Element, Key, ElementOps> (*(Implementation*) *new
                Instantiation (numberOfElements))
{
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IVGSortedMapAsList <Element, Key, ElementOps>::
IVGSortedMapAsList (PureImplementation& impl)
: IGSortedMapAsList
    <Element, Key, ElementOps> (impl)
{
}

// ---
// IVSortedMapAsList
// ---

// public members

template <class Element, class Key>
inline
IVSortedMapAsList <Element, Key>::
IVSortedMapAsList (INumber numberOfElements)
: IVGSortedMapAsList
   <Element, Key, IEKCOps <Element, Key> > (numberOfElements)
{
}

// protected members

template <class Element, class Key>
inline
IVSortedMapAsList <Element, Key>::
IVSortedMapAsList (PureImplementation& impl)
: IVGSortedMapAsList
   <Element, Key, IEKCOps <Element, Key> > (impl)
{
}
