/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _ISMTAB_H
#define _ISMTAB_H

#include <iasm.h>
#include <iicsm.h>
#include <iivsm.h>
#include <iismtab.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Element, class Key, class ElementOps>
class IGSortedMapAsTable;

template <class Element, class Key, class ElementOps>
class IGSortedMapAsTableCursor :
  public IOrderedCursor <Element> {

  typedef  IOrderedCursor <Element> Inherited;

  typedef  IGSortedMapAsTable
            <Element, Key, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGSortedMapAsTableCursor
                            (IGSortedMapAsTable
                              <
                               Element, Key, ElementOps> const&);

  IGSortedMapAsTableCursor <Element, Key, ElementOps>&
           operator=        (IGSortedMapAsTableCursor
                              <
                               Element, Key, ElementOps> const&);

protected:

           IGSortedMapAsTableCursor
                            (ICursorImpl*);

private:


};

template <class Element, class Key, class ElementOps>
class IGSortedMapAsTable :
  public IASortedMap <Element, Key> {
protected:

  typedef  IGSortedMapAsTable <Element, Key, ElementOps> Self;

  typedef  ISortedMapAsTableImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICSortedMapImpl
            <PureImplementation> Implementation;
#endif

#define IGSortedMapAsTableTypedef(Element, Key, ElementOps)\
  typedef  ISortedMapAsTableOps\
            <Element, Key,\
             IWEKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IGSortedMapAsTableTypedef (Element, Key, ElementOps);

public:

  typedef  IGSortedMapAsTableCursor
            <Element, Key, ElementOps> Cursor;


           IGSortedMapAsTable
                            (INumber = 100);

           IGSortedMapAsTable
                            (IGSortedMapAsTable
                              <
                               Element, Key, ElementOps> const&);

  IGSortedMapAsTable <Element, Key, ElementOps>&
           operator=        (IGSortedMapAsTable
                              <
                               Element, Key, ElementOps> const&);


protected:

           IGSortedMapAsTable
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGSortedMapAsTable
                              <
                               Element, Key, ElementOps> const&);

private:

  friend
  class    IGSortedMapAsTableCursor
            <Element, Key, ElementOps>;



};

template <class Element, class Key>
class ISortedMapAsTable :
  public IGSortedMapAsTable
          <Element, Key, IEKCOps <Element, Key> > {

  typedef  IGSortedMapAsTable
            <Element, Key,
             IEKCOps <Element, Key> > Inherited;

protected:

  typedef  ISortedMapAsTable <Element, Key> Self;

#define ISortedMapAsTableTypedef(Element, Key)\
  typedef  ISortedMapAsTableOps\
            <Element, Key,\
             IWEKCOps <Element, Key, IEKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

           ISortedMapAsTable
                            (INumber = 100);


protected:

           ISortedMapAsTable
                              (PureImplementation&);

private:


};

template <class Element, class Key, class ElementOps>
class IVGSortedMapAsTable :
  public IGSortedMapAsTable
          <Element, Key, ElementOps > {

  typedef  IVGSortedMapAsTable
            <Element, Key, ElementOps> Inherited;

protected:

#if defined (INO_CHECKS)
  typedef  IVSortedMapImpl
            <PureImplementation> Implementation;
#else
  typedef  ICSortedMapImpl
            <IVSortedMapImpl
              <PureImplementation> > Implementation;
#endif

#define IVGSortedMapAsTableTypedef(Element, Key, ElementOps)\
  typedef  ISortedMapAsTableOps\
            <Element, Key,\
             IWEKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IVGSortedMapAsTableTypedef (Element, Key, ElementOps);

public:

           IVGSortedMapAsTable
                            (INumber = 100);


protected:

           IVGSortedMapAsTable
                              (PureImplementation&);

private:


};

template <class Element, class Key>
class IVSortedMapAsTable :
  public IVGSortedMapAsTable
          <Element, Key, IEKCOps <Element, Key> > {

  typedef  IVGSortedMapAsTable
            <Element, Key,
             IEKCOps <Element, Key> > Inherited;

protected:

  typedef  IVSortedMapAsTable <Element, Key> Self;

#define IVSortedMapAsTableTypedef(Element, Key)\
  typedef  IVSortedMapAsTableOps\
            <Element, Key,\
             IWEKCOps <Element, Key, IEKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

           IVSortedMapAsTable
                            (INumber = 100);


protected:

           IVSortedMapAsTable
                              (PureImplementation&);

private:


};

#pragma SOMAsDefault (pop)

#include <ismtab.inl>

#pragma info (restore)
#pragma pack ()

#endif
