#ifndef _ISPINBAS_
  #define _ISPINBAS_
/*******************************************************************************
* FILE NAME: ispinbas.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IBaseSpinButton                                                          *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/

#include <icontrol.hpp>
#include <irect.hpp>
#include <ihandle.hpp>

class IBaseSpinButtonData;

#pragma pack(4)

class IBaseSpinButton : public IControl {
typedef IControl
  Inherited;

public :

/*----------------------------- Constructors ---------------------------------*/
virtual
  ~IBaseSpinButton ( );

/*----------------------------- Styles ---------------------------------------*/
INESTEDBITFLAGCLASSDEF2(Style, IBaseSpinButton, IWindow, IControl);

static const Style
  IC_IMPORTU master,
  IC_IMPORTU servant,
  IC_IMPORTU readOnly,
  IC_IMPORTU noBorder,
  IC_IMPORTU pmCompatible,
  IC_IMPORTU fastSpin;
#ifndef IC_MOTIFPM_FLAGNOP
static const Style
  IC_IMPORTU border3D;
#endif
static const Style
  IC_IMPORTU leftAlign,
  IC_IMPORTU centerAlign,
  IC_IMPORTU rightAlign;

  virtual unsigned long
    convertToGUIStyle ( const IBitFlag& style,
                        Boolean         extendedOnly = false ) const;

/*---------------------------- Style Functions -------------------------------*/
enum Alignment {
  left,
  right,
  center
};

virtual IBaseSpinButton
  &enableDataUpdate  ( Boolean   writeable = true ),
  &disableDataUpdate ( ),
  &enableFastSpin    ( Boolean   fast      = true ),
  &disableFastSpin   ( ),
  &addBorder         ( Boolean   add       = true ),
  &removeBorder      ( );
#ifndef IC_MOTIFWIN_FLAGNOP
virtual IBaseSpinButton
  &setAlignment      ( Alignment alignment = left );
#endif

Boolean
  isMaster          ( ) const,
  isServant         ( ) const,
  isWriteable       ( ) const,
  isFastSpinEnabled ( ) const,
  isPMCompatible    ( ) const,
  hasBorder         ( ) const;

Alignment
  alignment  ( ) const;

/*----------------------------- Limit and Spin -------------------------------*/
unsigned long
  limit ( ) const;

virtual IBaseSpinButton
  &setLimit  ( unsigned long    aNumber = 255 ),
  &setMaster ( IBaseSpinButton& master        ),
  &spinDown  ( unsigned long    spinBy  = 1 ),
  &spinUp    ( unsigned long    spinBy  = 1 );

virtual Boolean
  isSpinFieldValid ( Boolean caseSensitive ) const = 0;


/*--------------------------------- Overrides --------------------------------*/
virtual IBaseSpinButton
 &enable ( Boolean enable = true );

virtual IColor
  foregroundColor () const;

virtual IColor
  backgroundColor () const;

virtual IBaseSpinButton
 &setForegroundColor ( const IColor& color ),
 &setBackgroundColor ( const IColor& color ),
 &resetForegroundColor ( ),
 &resetBackgroundColor ( );

/*------------------------- Attributes ---------------------------------------*/
virtual Boolean
  hasFocus            ( ) const;


/*----------------------- Notification Event Descriptions --------------------*/
static INotificationId const
  IC_IMPORTU valueId,
  IC_IMPORTU textId;


protected:
/*------------------------------ Implementation ------------------------------*/
virtual ISize
  calcMinimumSize ( ) const;

void
  initialize ( unsigned long        windowId,
               const IWindowHandle& parent,
               const IWindowHandle& owner,
               unsigned long        style,
               const IRectangle&    initial );
virtual void
  initialize ( );

/*-------------------------- Protected Constructors --------------------------*/
  IBaseSpinButton ( );

/*---------------------- Event-Handling Implementation -----------------------*/


private:
/*------------------------------- Hidden Members -----------------------------*/
  IBaseSpinButton ( const IBaseSpinButton& spinButton );
IBaseSpinButton
 &operator=       ( const IBaseSpinButton& spinButton );

/*--------------------------------- Private ----------------------------------*/
friend class IBaseSpinDefaultHandler;

IBaseSpinButtonData
 *fBaseSpinButtonData;
};  // IBaseSpinButton

INESTEDBITFLAGCLASSFUNCS( Style, IBaseSpinButton);

#pragma pack()

#endif // _ISPINBAS_
