#ifndef _ISPINHDR_
  #define _ISPINHDR_
/*******************************************************************************
* FILE NAME: ispinhdr.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     ISpinHandler                                                             *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <ihandler.hpp>
#include <ictlevt.hpp>

#pragma pack(4)

class ISpinHandler : public IHandler {
typedef IHandler
  Inherited;

public:
/*-------------------------- Constructors -----------------------------------*/
virtual
 ~ISpinHandler ( );


protected:
/*------------------------- Protected Constructors --------------------------*/
  ISpinHandler ( );

/*---------------------------- Event Dispatching ----------------------------*/
virtual Boolean
  dispatchHandlerEvent ( IEvent& event );

/*----------------------------- Event Processing ----------------------------*/
virtual Boolean
  arrowUp              ( IControlEvent& event ),
  arrowDown            ( IControlEvent& event ),
  spinEnded            ( IControlEvent& event );
}; // ISpinHandler


#pragma pack()

#endif /* _ISPINHDR_ */
