#ifndef _ISPINTXT_
  #define _ISPINTXT_
/*******************************************************************************
* FILE NAME: ispintxt.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     ITextSpinButton                                                          *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/

#include <ispinbas.hpp>

class IString;
class ITextSpinButtonData;
class ITextSpinButtonCursorData;
class IResourceId;

#pragma pack(4)

class ITextSpinButton : public IBaseSpinButton {
typedef IBaseSpinButton
  Inherited;

public :
class Style;
class Cursor;
/*------------------------------- Constructors -------------------------------*/
   ITextSpinButton ( unsigned long     id,
                     IWindow*          parent,
                     IWindow*          owner,
                     const IRectangle& initial = IRectangle(),
                     const Style&      style   = defaultStyle() );

   ITextSpinButton ( unsigned long id,
                     IWindow*      parent );

   ITextSpinButton ( const IWindowHandle& handle );

virtual
  ~ITextSpinButton ( );

/*---------------------------------- Styles ----------------------------------*/
INESTEDBITFLAGCLASSDEF3(Style, ITextSpinButton, IBaseSpinButton,
                        IWindow, IControl);

static const Style
  IC_IMPORTU classDefaultStyle;

static Style
  defaultStyle      ( );

static void
  setDefaultStyle   ( const Style&    style );

  virtual unsigned long
    convertToGUIStyle ( const IBitFlag& style,
                        Boolean         extendedOnly = false ) const;

/*------------------------- Set Text and Validate ----------------------------*/
virtual ITextSpinButton
  &setText ( const char*        string ),
  &setText ( const IResourceId& item );

virtual IString
  text ( ) const;

virtual Boolean
  isSpinFieldValid ( Boolean caseSensitive = false) const;

/*-------------------------- Text-List Operations ----------------------------*/
virtual IString
  elementAt ( unsigned long index ) const,
  elementAt ( const Cursor& cursor ) const;

virtual ITextSpinButton
  &replaceAt  ( const char*        newString,
                Cursor&            cursor ),
  &replaceAt  ( const IResourceId& item,
                Cursor&            cursor ),
  &removeAt   ( Cursor&            cursor ),
  &removeAll  ( ),
  &add        ( const char*         string,
                Cursor&             cursor ),
  &add        ( const IResourceId&  item,
                Cursor&             cursor ),
  &add        ( const char*         string,
                unsigned long       index  ),
  &add        ( const IResourceId&  item,
                unsigned long       index  ),
  &add        ( const char* const * stringArray,
                unsigned long       index,
                unsigned long       count ),
  &addAsNext  ( const char*         string,
                Cursor&             cursor ),
  &addAsNext  ( const IResourceId&  item,
                Cursor&             cursor ),
  &addAsFirst ( const char*         string ),
  &addAsFirst ( const IResourceId&  item   ),
  &addAsLast  ( const char*         string ),
  &addAsLast  ( const IResourceId&  item   ),
  &spinTo     ( unsigned long       index  ),
  &spinTo     ( const Cursor&       cursor ),
  &spinTo     ( const char*         string,
                Boolean             caseSensitive = false );


/*----------------------- Observer Notification ------------------------------*/
virtual ITextSpinButton
 &enableNotification ( Boolean enable=true );

/*------------------------------ Nested Classes ------------------------------*/
class Cursor : public IVBase {

public:
/*---------------------------- Constructors -----------------------------*/
  Cursor  ( const ITextSpinButton& spinButton );

virtual
  ~Cursor ( );

/*--------------------------- Cursor Movement ---------------------------*/
virtual Boolean
  setToFirst    ( ),
  setToNext     ( ),
  setToPrevious ( ),
  setToLast     ( );

/*-------------------------- Cursor Validation --------------------------*/
virtual Boolean
  isValid    ( ) const;
virtual void
  invalidate ( );


private:
/*--------------------------- Hidden Members ----------------------------*/
  Cursor    ( const Cursor& cursor );
Cursor
  &operator= ( const Cursor& cursor );

/*--------------------------------- Private ----------------------------------*/
friend class ITextSpinButton;

ITextSpinButtonCursorData
 *fCursorData;
}; // ITextSpinButton::Cursor


private:
/*------------------------------ Hidden Members ------------------------------*/
ITextSpinButton ( const ITextSpinButton& spinButton );
ITextSpinButton
 &operator=     ( const ITextSpinButton& spinButton );

/*--------------------------------- Private ----------------------------------*/
friend class ITextSpinButton::Cursor;
friend class ITextSpinButtonCursorData;

unsigned
  findStringIndex(const Cursor& cursor) const,
  findStringIndex( unsigned long index ) const;
ITextSpinButton&
  refreshText ( );

static Style
  currentDefaultStyle;

ITextSpinButtonData
 *fTextSpinButtonData;
}; // ITextSpinButton

INESTEDBITFLAGCLASSFUNCS( Style, ITextSpinButton);

  #include <ispintxt.inl>

#pragma pack()

#endif // _ISPINTXT_
