#ifndef _ISPLITCV_
  #define _ISPLITCV_
/*******************************************************************************
* FILE NAME: isplitcv.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     ISplitCanvas                                                             *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <icanvas.hpp>
#include <icolor.hpp>
#include <inotify.hpp>
#include <ipoint.hpp>
#include <irect.hpp>

class ISplitBarSet;
class ISplitCanvasData;
class ISplitCanvasHandler;
class ISplitCanvasHandlerData;
class ISplitPercentage;
class ISplitPercentageSet;

#pragma pack(4)

class ISplitCanvas : public ICanvas {
typedef ICanvas
  Inherited;
public:
class Style;

/*------------------------------- Constructors -------------------------------*/
  ISplitCanvas ( unsigned long     windowIdentifier,
                 IWindow*          parent,
                 IWindow*          owner,
                 const IRectangle& initialSize = IRectangle(),
                 const Style&      style = defaultStyle() );

virtual
 ~ISplitCanvas ( );

/*---------------------------------- Styles ----------------------------------*/
INESTEDBITFLAGCLASSDEF2(Style, ISplitCanvas, ICanvas, IWindow);
static const Style
  IC_IMPORTU horizontal,
  IC_IMPORTU vertical,
  IC_IMPORTU noSplitBars,
  IC_IMPORTU classDefaultStyle;
static Style
  defaultStyle      ( );
static void
  setDefaultStyle   ( const Style&    style );

virtual unsigned long
  convertToGUIStyle ( const IBitFlag& style,
                      Boolean         extendedOnly = false ) const;

/*------------------------------- Orientation --------------------------------*/
enum Orientation  {
  horizontalSplit,
  verticalSplit
  };

Orientation
  orientation     ( ) const;

virtual ISplitCanvas
 &setOrientation  ( Orientation value );

/*--------------------------- Split Bar Thickness ----------------------------*/
enum SplitBarArea {
  splitBarEdge,
  splitBarMiddle
  };

virtual ISplitCanvas
 &setSplitBarThickness ( SplitBarArea  area,
                         unsigned long thickness );

unsigned long
  splitBarThickness    ( SplitBarArea  area );

/*--------------------------- Child Window Sizing ----------------------------*/
virtual ISplitCanvas
 &setSplitWindowPercentage ( IWindow*      window,
                             unsigned long percentage );

unsigned long
  splitWindowPercentage    ( IWindow* window );

/*---------------------------------- Layout Support --------------------------*/
virtual ISplitCanvas
 &setLayoutDistorted ( unsigned long layoutAttributesOn,
                       unsigned long layoutAttributesOff );

/*---------------------------- Notification Members --------------------------*/
static INotificationId const
  IC_IMPORTU orientationId;

/*---------------------------------- Colors ----------------------------------*/
virtual IColor
  splitBarEdgeColor        ( ) const;
virtual IColor
  splitBarMiddleColor      ( ) const;

virtual ISplitCanvas
 &setSplitBarEdgeColor     ( const IColor &color );
virtual ISplitCanvas
 &setSplitBarMiddleColor   ( const IColor &color );

virtual ISplitCanvas
 &resetSplitBarEdgeColor   ( ),
 &resetSplitBarMiddleColor ( );

protected:
/*---------------------------------- Layout Support --------------------------*/
virtual ISplitCanvas
 &layout ( );

private:
/*--------------------------------- Private ----------------------------------*/

/*----------------------------- Hidden Members -------------------------------*/
  ISplitCanvas ( const ISplitCanvas& canvas );
ISplitCanvas
 &operator=    ( const ISplitCanvas& canvas );

static Style
  currentDefaultStyle;

void
  resolveRatios ( );
ISplitCanvas
 &setResolvedPercentage ( IWindow*      window,
                          unsigned long percentage );
unsigned long
  resolvedPercentage    ( IWindow* window );

Boolean
  bClRatiosNotResolved;

unsigned long
  ulClMiddleThickness,
  ulClEdgeThickness,
  ulClChildCount;

IColor
  clrClMiddleColor,
  clrClEdgeColor;

ISize
  sizClCanvasSize;

ISplitPercentageSet
 *pClSplitPercentageSet;

ISplitCanvasHandler
 *pClSplitCanvasHandler;

ISplitBarSet
 *pClSplitBarSet;

ISplitCanvasData
 *fSplitCanvasData;

friend class ISplitCanvasHandler;

friend Boolean
  ISplitPercentageDeleter ( ISplitPercentage* const& splitPercentageObj,
                            void*                    anything );
}; // ISplitCanvas

INESTEDBITFLAGCLASSFUNCS(Style, ISplitCanvas);

#pragma pack()

  #include <isplitcv.inl>

#endif /* _ISPLITCV_ */
