/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _ISR_H
#define _ISR_H

#include <iasr.h>
#include <iicsr.h>
#include <iivsr.h>
#include <iisrlst.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Element, class Key, class ElementOps>
class IGSortedRelation;

template <class Element, class Key, class ElementOps>
class IGSortedRelationCursor :
  public IOrderedCursor <Element> {

  typedef  IOrderedCursor <Element> Inherited;

  typedef  IGSortedRelation
            <Element, Key, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGSortedRelationCursor
                            (IGSortedRelation
                              <
                               Element, Key, ElementOps> const&);

  IGSortedRelationCursor <Element, Key, ElementOps>&
           operator=        (IGSortedRelationCursor
                              <
                               Element, Key, ElementOps> const&);

protected:

           IGSortedRelationCursor
                            (ICursorImpl*);

private:


};

template <class Element, class Key, class ElementOps>
class IGSortedRelation :
  public IASortedRelation <Element, Key> {
protected:

  typedef  IGSortedRelation <Element, Key, ElementOps> Self;

  typedef  ISortedRelationAsListImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICSortedRelationImpl
            <PureImplementation> Implementation;
#endif

#define IGSortedRelationTypedef(Element, Key, ElementOps)\
  typedef  ISortedRelationAsListOps\
            <Element, Key,\
             IWEKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IGSortedRelationTypedef (Element, Key, ElementOps);

public:

  typedef  IGSortedRelationCursor
            <Element, Key, ElementOps> Cursor;


           IGSortedRelation
                            (INumber = 100);

           IGSortedRelation
                            (IGSortedRelation
                              <
                               Element, Key, ElementOps> const&);

  IGSortedRelation <Element, Key, ElementOps>&
           operator=        (IGSortedRelation
                              <
                               Element, Key, ElementOps> const&);


protected:

           IGSortedRelation
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGSortedRelation
                              <
                               Element, Key, ElementOps> const&);

private:

  friend
  class    IGSortedRelationCursor
            <Element, Key, ElementOps>;



};

template <class Element, class Key>
class ISortedRelation :
  public IGSortedRelation
          <Element, Key, IEKCOps <Element, Key> > {

  typedef  IGSortedRelation
            <Element, Key,
             IEKCOps <Element, Key> > Inherited;

protected:

  typedef  ISortedRelation <Element, Key> Self;

#define ISortedRelationTypedef(Element, Key)\
  typedef  ISortedRelationAsListOps\
            <Element, Key,\
             IWEKCOps <Element, Key, IEKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

           ISortedRelation
                            (INumber = 100);


protected:

           ISortedRelation
                              (PureImplementation&);

private:


};

template <class Element, class Key, class ElementOps>
class IVGSortedRelation :
  public IGSortedRelation
          <Element, Key, ElementOps > {

  typedef  IVGSortedRelation
            <Element, Key, ElementOps> Inherited;

protected:

#if defined (INO_CHECKS)
  typedef  IVSortedRelationImpl
            <PureImplementation> Implementation;
#else
  typedef  ICSortedRelationImpl
            <IVSortedRelationImpl
              <PureImplementation> > Implementation;
#endif

#define IVGSortedRelationTypedef(Element, Key, ElementOps)\
  typedef  ISortedRelationAsListOps\
            <Element, Key,\
             IWEKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IVGSortedRelationTypedef (Element, Key, ElementOps);

public:

           IVGSortedRelation
                            (INumber = 100);


protected:

           IVGSortedRelation
                              (PureImplementation&);

private:


};

template <class Element, class Key>
class IVSortedRelation :
  public IVGSortedRelation
          <Element, Key, IEKCOps <Element, Key> > {

  typedef  IVGSortedRelation
            <Element, Key,
             IEKCOps <Element, Key> > Inherited;

protected:

  typedef  IVSortedRelation <Element, Key> Self;

#define IVSortedRelationTypedef(Element, Key)\
  typedef  IVSortedRelationAsListOps\
            <Element, Key,\
             IWEKCOps <Element, Key, IEKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

           IVSortedRelation
                            (INumber = 100);


protected:

           IVSortedRelation
                              (PureImplementation&);

private:


};

#pragma SOMAsDefault (pop)

#include <isr.inl>

#pragma info (restore)
#pragma pack ()

#endif
