/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

// ---
// IGSortedRelationCursor
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IGSortedRelationCursor <Element, Key, ElementOps>::
IGSortedRelationCursor
  (IGSortedRelation
    <Element, Key, ElementOps> const& collection)
: IOrderedCursor <Element>
    (collection.ivImpl->CreateCursor ())
{
}

template <class Element, class Key, class ElementOps>
inline IGSortedRelationCursor <Element, Key, ElementOps>&
IGSortedRelationCursor <Element, Key, ElementOps>::
operator=
  (IGSortedRelationCursor
    <Element, Key, ElementOps> const& cursor)
{ Inherited::operator= (cursor);
  return *this;
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IGSortedRelationCursor <Element, Key, ElementOps>::
IGSortedRelationCursor (ICursorImpl* impl)
: IOrderedCursor <Element> (impl)
{
}

// ---
// IGSortedRelation
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IGSortedRelation <Element, Key, ElementOps>::
IGSortedRelation (INumber numberOfElements)
{ SetImpl ((Implementation*) *new
                Instantiation (numberOfElements));
}

template <class Element, class Key, class ElementOps>
inline
IGSortedRelation <Element, Key, ElementOps>::
IGSortedRelation
  (IGSortedRelation
    <Element, Key, ElementOps> const& collection)
{ CloneImplOf (collection);
}

template <class Element, class Key, class ElementOps>
inline IGSortedRelation <Element, Key, ElementOps>&
IGSortedRelation <Element, Key, ElementOps>::
operator= (IGSortedRelation
            <Element, Key, ElementOps> const& collection)
{ ImplOf (*this).Copy (ImplOf (collection));
  return *this;
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IGSortedRelation <Element, Key, ElementOps>::
IGSortedRelation (PureImplementation& impl)
{ SetImpl (&impl);
}

template <class Element, class Key, class ElementOps>
inline IGSortedRelation
 <Element, Key, ElementOps>::Implementation&
IGSortedRelation <Element, Key, ElementOps>::
ImplOf (IGSortedRelation
         <Element, Key, ElementOps> const& collection)
{ return *(Implementation*)collection.ivImpl;
}

// ---
// ISortedRelation
// ---

// public members

template <class Element, class Key>
inline
ISortedRelation <Element, Key>::
ISortedRelation (INumber numberOfElements)
: IGSortedRelation
   <Element, Key, IEKCOps <Element, Key> > (numberOfElements)
{
}

// protected members

template <class Element, class Key>
inline
ISortedRelation <Element, Key>::
ISortedRelation (PureImplementation& impl)
: IGSortedRelation
   <Element, Key, IEKCOps <Element, Key> > (impl)
{
}

// ---
// IVGSortedRelation
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IVGSortedRelation <Element, Key, ElementOps>::
IVGSortedRelation (INumber numberOfElements)
: IGSortedRelation
    <Element, Key, ElementOps> (*(Implementation*) *new
                Instantiation (numberOfElements))
{
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IVGSortedRelation <Element, Key, ElementOps>::
IVGSortedRelation (PureImplementation& impl)
: IGSortedRelation
    <Element, Key, ElementOps> (impl)
{
}

// ---
// IVSortedRelation
// ---

// public members

template <class Element, class Key>
inline
IVSortedRelation <Element, Key>::
IVSortedRelation (INumber numberOfElements)
: IVGSortedRelation
   <Element, Key, IEKCOps <Element, Key> > (numberOfElements)
{
}

// protected members

template <class Element, class Key>
inline
IVSortedRelation <Element, Key>::
IVSortedRelation (PureImplementation& impl)
: IVGSortedRelation
   <Element, Key, IEKCOps <Element, Key> > (impl)
{
}
