/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _ISRDIL_H
#define _ISRDIL_H

#include <iasr.h>
#include <iicsr.h>
#include <iivsr.h>
#include <iisrdil.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Element, class Key, class ElementOps>
class IGSortedRelationAsDilTable;

template <class Element, class Key, class ElementOps>
class IGSortedRelationAsDilTableCursor :
  public IOrderedCursor <Element> {

  typedef  IOrderedCursor <Element> Inherited;

  typedef  IGSortedRelationAsDilTable
            <Element, Key, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGSortedRelationAsDilTableCursor
                            (IGSortedRelationAsDilTable
                              <
                               Element, Key, ElementOps> const&);

  IGSortedRelationAsDilTableCursor <Element, Key, ElementOps>&
           operator=        (IGSortedRelationAsDilTableCursor
                              <
                               Element, Key, ElementOps> const&);

protected:

           IGSortedRelationAsDilTableCursor
                            (ICursorImpl*);

private:


};

template <class Element, class Key, class ElementOps>
class IGSortedRelationAsDilTable :
  public IASortedRelation <Element, Key> {
protected:

  typedef  IGSortedRelationAsDilTable <Element, Key, ElementOps> Self;

  typedef  ISortedRelationAsDilTableImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICSortedRelationImpl
            <PureImplementation> Implementation;
#endif

#define IGSortedRelationAsDilTableTypedef(Element, Key, ElementOps)\
  typedef  ISortedRelationAsDilTableOps\
            <Element, Key,\
             IWEKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IGSortedRelationAsDilTableTypedef (Element, Key, ElementOps);

public:

  typedef  IGSortedRelationAsDilTableCursor
            <Element, Key, ElementOps> Cursor;


           IGSortedRelationAsDilTable
                            (INumber = 100);

           IGSortedRelationAsDilTable
                            (IGSortedRelationAsDilTable
                              <
                               Element, Key, ElementOps> const&);

  IGSortedRelationAsDilTable <Element, Key, ElementOps>&
           operator=        (IGSortedRelationAsDilTable
                              <
                               Element, Key, ElementOps> const&);


protected:

           IGSortedRelationAsDilTable
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGSortedRelationAsDilTable
                              <
                               Element, Key, ElementOps> const&);

private:

  friend
  class    IGSortedRelationAsDilTableCursor
            <Element, Key, ElementOps>;



};

template <class Element, class Key>
class ISortedRelationAsDilTable :
  public IGSortedRelationAsDilTable
          <Element, Key, IEKCOps <Element, Key> > {

  typedef  IGSortedRelationAsDilTable
            <Element, Key,
             IEKCOps <Element, Key> > Inherited;

protected:

  typedef  ISortedRelationAsDilTable <Element, Key> Self;

#define ISortedRelationAsDilTableTypedef(Element, Key)\
  typedef  ISortedRelationAsDilTableOps\
            <Element, Key,\
             IWEKCOps <Element, Key, IEKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

           ISortedRelationAsDilTable
                            (INumber = 100);


protected:

           ISortedRelationAsDilTable
                              (PureImplementation&);

private:


};

template <class Element, class Key, class ElementOps>
class IVGSortedRelationAsDilTable :
  public IGSortedRelationAsDilTable
          <Element, Key, ElementOps > {

  typedef  IVGSortedRelationAsDilTable
            <Element, Key, ElementOps> Inherited;

protected:

#if defined (INO_CHECKS)
  typedef  IVSortedRelationImpl
            <PureImplementation> Implementation;
#else
  typedef  ICSortedRelationImpl
            <IVSortedRelationImpl
              <PureImplementation> > Implementation;
#endif

#define IVGSortedRelationAsDilTableTypedef(Element, Key, ElementOps)\
  typedef  ISortedRelationAsDilTableOps\
            <Element, Key,\
             IWEKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IVGSortedRelationAsDilTableTypedef (Element, Key, ElementOps);

public:

           IVGSortedRelationAsDilTable
                            (INumber = 100);


protected:

           IVGSortedRelationAsDilTable
                              (PureImplementation&);

private:


};

template <class Element, class Key>
class IVSortedRelationAsDilTable :
  public IVGSortedRelationAsDilTable
          <Element, Key, IEKCOps <Element, Key> > {

  typedef  IVGSortedRelationAsDilTable
            <Element, Key,
             IEKCOps <Element, Key> > Inherited;

protected:

  typedef  IVSortedRelationAsDilTable <Element, Key> Self;

#define IVSortedRelationAsDilTableTypedef(Element, Key)\
  typedef  IVSortedRelationAsDilTableOps\
            <Element, Key,\
             IWEKCOps <Element, Key, IEKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

           IVSortedRelationAsDilTable
                            (INumber = 100);


protected:

           IVSortedRelationAsDilTable
                              (PureImplementation&);

private:


};

#pragma SOMAsDefault (pop)

#include <isrdil.inl>

#pragma info (restore)
#pragma pack ()

#endif
