/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

// ---
// IGSortedRelationAsDilTableCursor
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IGSortedRelationAsDilTableCursor <Element, Key, ElementOps>::
IGSortedRelationAsDilTableCursor
  (IGSortedRelationAsDilTable
    <Element, Key, ElementOps> const& collection)
: IOrderedCursor <Element>
    (collection.ivImpl->CreateCursor ())
{
}

template <class Element, class Key, class ElementOps>
inline IGSortedRelationAsDilTableCursor <Element, Key, ElementOps>&
IGSortedRelationAsDilTableCursor <Element, Key, ElementOps>::
operator=
  (IGSortedRelationAsDilTableCursor
    <Element, Key, ElementOps> const& cursor)
{ Inherited::operator= (cursor);
  return *this;
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IGSortedRelationAsDilTableCursor <Element, Key, ElementOps>::
IGSortedRelationAsDilTableCursor (ICursorImpl* impl)
: IOrderedCursor <Element> (impl)
{
}

// ---
// IGSortedRelationAsDilTable
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IGSortedRelationAsDilTable <Element, Key, ElementOps>::
IGSortedRelationAsDilTable (INumber numberOfElements)
{ SetImpl ((Implementation*) *new
                Instantiation (numberOfElements));
}

template <class Element, class Key, class ElementOps>
inline
IGSortedRelationAsDilTable <Element, Key, ElementOps>::
IGSortedRelationAsDilTable
  (IGSortedRelationAsDilTable
    <Element, Key, ElementOps> const& collection)
{ CloneImplOf (collection);
}

template <class Element, class Key, class ElementOps>
inline IGSortedRelationAsDilTable <Element, Key, ElementOps>&
IGSortedRelationAsDilTable <Element, Key, ElementOps>::
operator= (IGSortedRelationAsDilTable
            <Element, Key, ElementOps> const& collection)
{ ImplOf (*this).Copy (ImplOf (collection));
  return *this;
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IGSortedRelationAsDilTable <Element, Key, ElementOps>::
IGSortedRelationAsDilTable (PureImplementation& impl)
{ SetImpl (&impl);
}

template <class Element, class Key, class ElementOps>
inline IGSortedRelationAsDilTable
 <Element, Key, ElementOps>::Implementation&
IGSortedRelationAsDilTable <Element, Key, ElementOps>::
ImplOf (IGSortedRelationAsDilTable
         <Element, Key, ElementOps> const& collection)
{ return *(Implementation*)collection.ivImpl;
}

// ---
// ISortedRelationAsDilTable
// ---

// public members

template <class Element, class Key>
inline
ISortedRelationAsDilTable <Element, Key>::
ISortedRelationAsDilTable (INumber numberOfElements)
: IGSortedRelationAsDilTable
   <Element, Key, IEKCOps <Element, Key> > (numberOfElements)
{
}

// protected members

template <class Element, class Key>
inline
ISortedRelationAsDilTable <Element, Key>::
ISortedRelationAsDilTable (PureImplementation& impl)
: IGSortedRelationAsDilTable
   <Element, Key, IEKCOps <Element, Key> > (impl)
{
}

// ---
// IVGSortedRelationAsDilTable
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IVGSortedRelationAsDilTable <Element, Key, ElementOps>::
IVGSortedRelationAsDilTable (INumber numberOfElements)
: IGSortedRelationAsDilTable
    <Element, Key, ElementOps> (*(Implementation*) *new
                Instantiation (numberOfElements))
{
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IVGSortedRelationAsDilTable <Element, Key, ElementOps>::
IVGSortedRelationAsDilTable (PureImplementation& impl)
: IGSortedRelationAsDilTable
    <Element, Key, ElementOps> (impl)
{
}

// ---
// IVSortedRelationAsDilTable
// ---

// public members

template <class Element, class Key>
inline
IVSortedRelationAsDilTable <Element, Key>::
IVSortedRelationAsDilTable (INumber numberOfElements)
: IVGSortedRelationAsDilTable
   <Element, Key, IEKCOps <Element, Key> > (numberOfElements)
{
}

// protected members

template <class Element, class Key>
inline
IVSortedRelationAsDilTable <Element, Key>::
IVSortedRelationAsDilTable (PureImplementation& impl)
: IVGSortedRelationAsDilTable
   <Element, Key, IEKCOps <Element, Key> > (impl)
{
}
