/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

// ---
// IGSortedRelationAsListCursor
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IGSortedRelationAsListCursor <Element, Key, ElementOps>::
IGSortedRelationAsListCursor
  (IGSortedRelationAsList
    <Element, Key, ElementOps> const& collection)
: IOrderedCursor <Element>
    (collection.ivImpl->CreateCursor ())
{
}

template <class Element, class Key, class ElementOps>
inline IGSortedRelationAsListCursor <Element, Key, ElementOps>&
IGSortedRelationAsListCursor <Element, Key, ElementOps>::
operator=
  (IGSortedRelationAsListCursor
    <Element, Key, ElementOps> const& cursor)
{ Inherited::operator= (cursor);
  return *this;
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IGSortedRelationAsListCursor <Element, Key, ElementOps>::
IGSortedRelationAsListCursor (ICursorImpl* impl)
: IOrderedCursor <Element> (impl)
{
}

// ---
// IGSortedRelationAsList
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IGSortedRelationAsList <Element, Key, ElementOps>::
IGSortedRelationAsList (INumber numberOfElements)
{ SetImpl ((Implementation*) *new
                Instantiation (numberOfElements));
}

template <class Element, class Key, class ElementOps>
inline
IGSortedRelationAsList <Element, Key, ElementOps>::
IGSortedRelationAsList
  (IGSortedRelationAsList
    <Element, Key, ElementOps> const& collection)
{ CloneImplOf (collection);
}

template <class Element, class Key, class ElementOps>
inline IGSortedRelationAsList <Element, Key, ElementOps>&
IGSortedRelationAsList <Element, Key, ElementOps>::
operator= (IGSortedRelationAsList
            <Element, Key, ElementOps> const& collection)
{ ImplOf (*this).Copy (ImplOf (collection));
  return *this;
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IGSortedRelationAsList <Element, Key, ElementOps>::
IGSortedRelationAsList (PureImplementation& impl)
{ SetImpl (&impl);
}

template <class Element, class Key, class ElementOps>
inline IGSortedRelationAsList
 <Element, Key, ElementOps>::Implementation&
IGSortedRelationAsList <Element, Key, ElementOps>::
ImplOf (IGSortedRelationAsList
         <Element, Key, ElementOps> const& collection)
{ return *(Implementation*)collection.ivImpl;
}

// ---
// ISortedRelationAsList
// ---

// public members

template <class Element, class Key>
inline
ISortedRelationAsList <Element, Key>::
ISortedRelationAsList (INumber numberOfElements)
: IGSortedRelationAsList
   <Element, Key, IEKCOps <Element, Key> > (numberOfElements)
{
}

// protected members

template <class Element, class Key>
inline
ISortedRelationAsList <Element, Key>::
ISortedRelationAsList (PureImplementation& impl)
: IGSortedRelationAsList
   <Element, Key, IEKCOps <Element, Key> > (impl)
{
}

// ---
// IVGSortedRelationAsList
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IVGSortedRelationAsList <Element, Key, ElementOps>::
IVGSortedRelationAsList (INumber numberOfElements)
: IGSortedRelationAsList
    <Element, Key, ElementOps> (*(Implementation*) *new
                Instantiation (numberOfElements))
{
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IVGSortedRelationAsList <Element, Key, ElementOps>::
IVGSortedRelationAsList (PureImplementation& impl)
: IGSortedRelationAsList
    <Element, Key, ElementOps> (impl)
{
}

// ---
// IVSortedRelationAsList
// ---

// public members

template <class Element, class Key>
inline
IVSortedRelationAsList <Element, Key>::
IVSortedRelationAsList (INumber numberOfElements)
: IVGSortedRelationAsList
   <Element, Key, IEKCOps <Element, Key> > (numberOfElements)
{
}

// protected members

template <class Element, class Key>
inline
IVSortedRelationAsList <Element, Key>::
IVSortedRelationAsList (PureImplementation& impl)
: IVGSortedRelationAsList
   <Element, Key, IEKCOps <Element, Key> > (impl)
{
}
