/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _ISRTAB_H
#define _ISRTAB_H

#include <iasr.h>
#include <iicsr.h>
#include <iivsr.h>
#include <iisrtab.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Element, class Key, class ElementOps>
class IGSortedRelationAsTable;

template <class Element, class Key, class ElementOps>
class IGSortedRelationAsTableCursor :
  public IOrderedCursor <Element> {

  typedef  IOrderedCursor <Element> Inherited;

  typedef  IGSortedRelationAsTable
            <Element, Key, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGSortedRelationAsTableCursor
                            (IGSortedRelationAsTable
                              <
                               Element, Key, ElementOps> const&);

  IGSortedRelationAsTableCursor <Element, Key, ElementOps>&
           operator=        (IGSortedRelationAsTableCursor
                              <
                               Element, Key, ElementOps> const&);

protected:

           IGSortedRelationAsTableCursor
                            (ICursorImpl*);

private:


};

template <class Element, class Key, class ElementOps>
class IGSortedRelationAsTable :
  public IASortedRelation <Element, Key> {
protected:

  typedef  IGSortedRelationAsTable <Element, Key, ElementOps> Self;

  typedef  ISortedRelationAsTableImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICSortedRelationImpl
            <PureImplementation> Implementation;
#endif

#define IGSortedRelationAsTableTypedef(Element, Key, ElementOps)\
  typedef  ISortedRelationAsTableOps\
            <Element, Key,\
             IWEKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IGSortedRelationAsTableTypedef (Element, Key, ElementOps);

public:

  typedef  IGSortedRelationAsTableCursor
            <Element, Key, ElementOps> Cursor;


           IGSortedRelationAsTable
                            (INumber = 100);

           IGSortedRelationAsTable
                            (IGSortedRelationAsTable
                              <
                               Element, Key, ElementOps> const&);

  IGSortedRelationAsTable <Element, Key, ElementOps>&
           operator=        (IGSortedRelationAsTable
                              <
                               Element, Key, ElementOps> const&);


protected:

           IGSortedRelationAsTable
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGSortedRelationAsTable
                              <
                               Element, Key, ElementOps> const&);

private:

  friend
  class    IGSortedRelationAsTableCursor
            <Element, Key, ElementOps>;



};

template <class Element, class Key>
class ISortedRelationAsTable :
  public IGSortedRelationAsTable
          <Element, Key, IEKCOps <Element, Key> > {

  typedef  IGSortedRelationAsTable
            <Element, Key,
             IEKCOps <Element, Key> > Inherited;

protected:

  typedef  ISortedRelationAsTable <Element, Key> Self;

#define ISortedRelationAsTableTypedef(Element, Key)\
  typedef  ISortedRelationAsTableOps\
            <Element, Key,\
             IWEKCOps <Element, Key, IEKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

           ISortedRelationAsTable
                            (INumber = 100);


protected:

           ISortedRelationAsTable
                              (PureImplementation&);

private:


};

template <class Element, class Key, class ElementOps>
class IVGSortedRelationAsTable :
  public IGSortedRelationAsTable
          <Element, Key, ElementOps > {

  typedef  IVGSortedRelationAsTable
            <Element, Key, ElementOps> Inherited;

protected:

#if defined (INO_CHECKS)
  typedef  IVSortedRelationImpl
            <PureImplementation> Implementation;
#else
  typedef  ICSortedRelationImpl
            <IVSortedRelationImpl
              <PureImplementation> > Implementation;
#endif

#define IVGSortedRelationAsTableTypedef(Element, Key, ElementOps)\
  typedef  ISortedRelationAsTableOps\
            <Element, Key,\
             IWEKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IVGSortedRelationAsTableTypedef (Element, Key, ElementOps);

public:

           IVGSortedRelationAsTable
                            (INumber = 100);


protected:

           IVGSortedRelationAsTable
                              (PureImplementation&);

private:


};

template <class Element, class Key>
class IVSortedRelationAsTable :
  public IVGSortedRelationAsTable
          <Element, Key, IEKCOps <Element, Key> > {

  typedef  IVGSortedRelationAsTable
            <Element, Key,
             IEKCOps <Element, Key> > Inherited;

protected:

  typedef  IVSortedRelationAsTable <Element, Key> Self;

#define IVSortedRelationAsTableTypedef(Element, Key)\
  typedef  IVSortedRelationAsTableOps\
            <Element, Key,\
             IWEKCOps <Element, Key, IEKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

           IVSortedRelationAsTable
                            (INumber = 100);


protected:

           IVSortedRelationAsTable
                              (PureImplementation&);

private:


};

#pragma SOMAsDefault (pop)

#include <isrtab.inl>

#pragma info (restore)
#pragma pack ()

#endif
