/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

// ---
// IGSortedRelationAsTableCursor
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IGSortedRelationAsTableCursor <Element, Key, ElementOps>::
IGSortedRelationAsTableCursor
  (IGSortedRelationAsTable
    <Element, Key, ElementOps> const& collection)
: IOrderedCursor <Element>
    (collection.ivImpl->CreateCursor ())
{
}

template <class Element, class Key, class ElementOps>
inline IGSortedRelationAsTableCursor <Element, Key, ElementOps>&
IGSortedRelationAsTableCursor <Element, Key, ElementOps>::
operator=
  (IGSortedRelationAsTableCursor
    <Element, Key, ElementOps> const& cursor)
{ Inherited::operator= (cursor);
  return *this;
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IGSortedRelationAsTableCursor <Element, Key, ElementOps>::
IGSortedRelationAsTableCursor (ICursorImpl* impl)
: IOrderedCursor <Element> (impl)
{
}

// ---
// IGSortedRelationAsTable
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IGSortedRelationAsTable <Element, Key, ElementOps>::
IGSortedRelationAsTable (INumber numberOfElements)
{ SetImpl ((Implementation*) *new
                Instantiation (numberOfElements));
}

template <class Element, class Key, class ElementOps>
inline
IGSortedRelationAsTable <Element, Key, ElementOps>::
IGSortedRelationAsTable
  (IGSortedRelationAsTable
    <Element, Key, ElementOps> const& collection)
{ CloneImplOf (collection);
}

template <class Element, class Key, class ElementOps>
inline IGSortedRelationAsTable <Element, Key, ElementOps>&
IGSortedRelationAsTable <Element, Key, ElementOps>::
operator= (IGSortedRelationAsTable
            <Element, Key, ElementOps> const& collection)
{ ImplOf (*this).Copy (ImplOf (collection));
  return *this;
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IGSortedRelationAsTable <Element, Key, ElementOps>::
IGSortedRelationAsTable (PureImplementation& impl)
{ SetImpl (&impl);
}

template <class Element, class Key, class ElementOps>
inline IGSortedRelationAsTable
 <Element, Key, ElementOps>::Implementation&
IGSortedRelationAsTable <Element, Key, ElementOps>::
ImplOf (IGSortedRelationAsTable
         <Element, Key, ElementOps> const& collection)
{ return *(Implementation*)collection.ivImpl;
}

// ---
// ISortedRelationAsTable
// ---

// public members

template <class Element, class Key>
inline
ISortedRelationAsTable <Element, Key>::
ISortedRelationAsTable (INumber numberOfElements)
: IGSortedRelationAsTable
   <Element, Key, IEKCOps <Element, Key> > (numberOfElements)
{
}

// protected members

template <class Element, class Key>
inline
ISortedRelationAsTable <Element, Key>::
ISortedRelationAsTable (PureImplementation& impl)
: IGSortedRelationAsTable
   <Element, Key, IEKCOps <Element, Key> > (impl)
{
}

// ---
// IVGSortedRelationAsTable
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IVGSortedRelationAsTable <Element, Key, ElementOps>::
IVGSortedRelationAsTable (INumber numberOfElements)
: IGSortedRelationAsTable
    <Element, Key, ElementOps> (*(Implementation*) *new
                Instantiation (numberOfElements))
{
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IVGSortedRelationAsTable <Element, Key, ElementOps>::
IVGSortedRelationAsTable (PureImplementation& impl)
: IGSortedRelationAsTable
    <Element, Key, ElementOps> (impl)
{
}

// ---
// IVSortedRelationAsTable
// ---

// public members

template <class Element, class Key>
inline
IVSortedRelationAsTable <Element, Key>::
IVSortedRelationAsTable (INumber numberOfElements)
: IVGSortedRelationAsTable
   <Element, Key, IEKCOps <Element, Key> > (numberOfElements)
{
}

// protected members

template <class Element, class Key>
inline
IVSortedRelationAsTable <Element, Key>::
IVSortedRelationAsTable (PureImplementation& impl)
: IVGSortedRelationAsTable
   <Element, Key, IEKCOps <Element, Key> > (impl)
{
}
