/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _ISSAVL_H
#define _ISSAVL_H

#include <iass.h>
#include <iicss.h>
#include <iivss.h>
#include <iissavl.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Element, class ElementOps>
class IGSortedSetAsAvlTree;

template <class Element, class ElementOps>
class IGSortedSetAsAvlTreeCursor :
  public IOrderedCursor <Element> {

  typedef  IOrderedCursor <Element> Inherited;

  typedef  IGSortedSetAsAvlTree
            <Element, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGSortedSetAsAvlTreeCursor
                            (IGSortedSetAsAvlTree
                              <
                               Element, ElementOps> const&);

  IGSortedSetAsAvlTreeCursor <Element, ElementOps>&
           operator=        (IGSortedSetAsAvlTreeCursor
                              <
                               Element, ElementOps> const&);

protected:

           IGSortedSetAsAvlTreeCursor
                            (ICursorImpl*);

private:


};

template <class Element, class ElementOps>
class IGSortedSetAsAvlTree :
  public IASortedSet <Element> {
protected:

  typedef  IGSortedSetAsAvlTree <Element, ElementOps> Self;

  typedef  ISortedSetAsAvlTreeImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICSortedSetImpl
            <PureImplementation> Implementation;
#endif

#define IGSortedSetAsAvlTreeTypedef(Element, ElementOps)\
  typedef  ISortedSetAsAvlTreeOps\
            <Element,\
             IWCOps <Element, ElementOps>,\
             Implementation> Instantiation

           IGSortedSetAsAvlTreeTypedef (Element, ElementOps);

public:

  typedef  IGSortedSetAsAvlTreeCursor
            <Element, ElementOps> Cursor;


           IGSortedSetAsAvlTree
                            (INumber = 100);

           IGSortedSetAsAvlTree
                            (IGSortedSetAsAvlTree
                              <
                               Element, ElementOps> const&);

  IGSortedSetAsAvlTree <Element, ElementOps>&
           operator=        (IGSortedSetAsAvlTree
                              <
                               Element, ElementOps> const&);


protected:

           IGSortedSetAsAvlTree
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGSortedSetAsAvlTree
                              <
                               Element, ElementOps> const&);

private:

  friend
  class    IGSortedSetAsAvlTreeCursor
            <Element, ElementOps>;



};

template <class Element>
class ISortedSetAsAvlTree :
  public IGSortedSetAsAvlTree
          <Element, ICOps <Element> > {

  typedef  IGSortedSetAsAvlTree
            <Element,
             ICOps <Element> > Inherited;

protected:

  typedef  ISortedSetAsAvlTree <Element> Self;

#define ISortedSetAsAvlTreeTypedef(Element)\
  typedef  ISortedSetAsAvlTreeOps\
            <Element,\
             IWCOps <Element, ICOps <Element> >,\
             Implementation> Instantiation

public:

           ISortedSetAsAvlTree
                            (INumber = 100);


protected:

           ISortedSetAsAvlTree
                              (PureImplementation&);

private:


};

template <class Element, class ElementOps>
class IVGSortedSetAsAvlTree :
  public IGSortedSetAsAvlTree
          <Element, ElementOps > {

  typedef  IVGSortedSetAsAvlTree
            <Element, ElementOps> Inherited;

protected:

#if defined (INO_CHECKS)
  typedef  IVSortedSetImpl
            <PureImplementation> Implementation;
#else
  typedef  ICSortedSetImpl
            <IVSortedSetImpl
              <PureImplementation> > Implementation;
#endif

#define IVGSortedSetAsAvlTreeTypedef(Element, ElementOps)\
  typedef  ISortedSetAsAvlTreeOps\
            <Element,\
             IWCOps <Element, ElementOps>,\
             Implementation> Instantiation

           IVGSortedSetAsAvlTreeTypedef (Element, ElementOps);

public:

           IVGSortedSetAsAvlTree
                            (INumber = 100);


protected:

           IVGSortedSetAsAvlTree
                              (PureImplementation&);

private:


};

template <class Element>
class IVSortedSetAsAvlTree :
  public IVGSortedSetAsAvlTree
          <Element, ICOps <Element> > {

  typedef  IVGSortedSetAsAvlTree
            <Element,
             ICOps <Element> > Inherited;

protected:

  typedef  IVSortedSetAsAvlTree <Element> Self;

#define IVSortedSetAsAvlTreeTypedef(Element)\
  typedef  IVSortedSetAsAvlTreeOps\
            <Element,\
             IWCOps <Element, ICOps <Element> >,\
             Implementation> Instantiation

public:

           IVSortedSetAsAvlTree
                            (INumber = 100);


protected:

           IVSortedSetAsAvlTree
                              (PureImplementation&);

private:


};

#pragma SOMAsDefault (pop)

#include <issavl.inl>

#pragma info (restore)
#pragma pack ()

#endif
