/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

// ---
// IGSortedSetAsAvlTreeCursor
// ---

// public members

template <class Element, class ElementOps>
inline
IGSortedSetAsAvlTreeCursor <Element, ElementOps>::
IGSortedSetAsAvlTreeCursor
  (IGSortedSetAsAvlTree
    <Element, ElementOps> const& collection)
: IOrderedCursor <Element>
    (collection.ivImpl->CreateCursor ())
{
}

template <class Element, class ElementOps>
inline IGSortedSetAsAvlTreeCursor <Element, ElementOps>&
IGSortedSetAsAvlTreeCursor <Element, ElementOps>::
operator=
  (IGSortedSetAsAvlTreeCursor
    <Element, ElementOps> const& cursor)
{ Inherited::operator= (cursor);
  return *this;
}

// protected members

template <class Element, class ElementOps>
inline
IGSortedSetAsAvlTreeCursor <Element, ElementOps>::
IGSortedSetAsAvlTreeCursor (ICursorImpl* impl)
: IOrderedCursor <Element> (impl)
{
}

// ---
// IGSortedSetAsAvlTree
// ---

// public members

template <class Element, class ElementOps>
inline
IGSortedSetAsAvlTree <Element, ElementOps>::
IGSortedSetAsAvlTree (INumber numberOfElements)
{ SetImpl ((Implementation*) *new
                Instantiation (numberOfElements));
}

template <class Element, class ElementOps>
inline
IGSortedSetAsAvlTree <Element, ElementOps>::
IGSortedSetAsAvlTree
  (IGSortedSetAsAvlTree
    <Element, ElementOps> const& collection)
{ CloneImplOf (collection);
}

template <class Element, class ElementOps>
inline IGSortedSetAsAvlTree <Element, ElementOps>&
IGSortedSetAsAvlTree <Element, ElementOps>::
operator= (IGSortedSetAsAvlTree
            <Element, ElementOps> const& collection)
{ ImplOf (*this).Copy (ImplOf (collection));
  return *this;
}

// protected members

template <class Element, class ElementOps>
inline
IGSortedSetAsAvlTree <Element, ElementOps>::
IGSortedSetAsAvlTree (PureImplementation& impl)
{ SetImpl (&impl);
}

template <class Element, class ElementOps>
inline IGSortedSetAsAvlTree
 <Element, ElementOps>::Implementation&
IGSortedSetAsAvlTree <Element, ElementOps>::
ImplOf (IGSortedSetAsAvlTree
         <Element, ElementOps> const& collection)
{ return *(Implementation*)collection.ivImpl;
}

// ---
// ISortedSetAsAvlTree
// ---

// public members

template <class Element>
inline
ISortedSetAsAvlTree <Element>::
ISortedSetAsAvlTree (INumber numberOfElements)
: IGSortedSetAsAvlTree
   <Element, ICOps <Element> > (numberOfElements)
{
}

// protected members

template <class Element>
inline
ISortedSetAsAvlTree <Element>::
ISortedSetAsAvlTree (PureImplementation& impl)
: IGSortedSetAsAvlTree
   <Element, ICOps <Element> > (impl)
{
}

// ---
// IVGSortedSetAsAvlTree
// ---

// public members

template <class Element, class ElementOps>
inline
IVGSortedSetAsAvlTree <Element, ElementOps>::
IVGSortedSetAsAvlTree (INumber numberOfElements)
: IGSortedSetAsAvlTree
    <Element, ElementOps> (*(Implementation*) *new
                Instantiation (numberOfElements))
{
}

// protected members

template <class Element, class ElementOps>
inline
IVGSortedSetAsAvlTree <Element, ElementOps>::
IVGSortedSetAsAvlTree (PureImplementation& impl)
: IGSortedSetAsAvlTree
    <Element, ElementOps> (impl)
{
}

// ---
// IVSortedSetAsAvlTree
// ---

// public members

template <class Element>
inline
IVSortedSetAsAvlTree <Element>::
IVSortedSetAsAvlTree (INumber numberOfElements)
: IVGSortedSetAsAvlTree
   <Element, ICOps <Element> > (numberOfElements)
{
}

// protected members

template <class Element>
inline
IVSortedSetAsAvlTree <Element>::
IVSortedSetAsAvlTree (PureImplementation& impl)
: IVGSortedSetAsAvlTree
   <Element, ICOps <Element> > (impl)
{
}
