/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

// ---
// IGSortedSetAsBstTreeCursor
// ---

// public members

template <class Element, class ElementOps>
inline
IGSortedSetAsBstTreeCursor <Element, ElementOps>::
IGSortedSetAsBstTreeCursor
  (IGSortedSetAsBstTree
    <Element, ElementOps> const& collection)
: IOrderedCursor <Element>
    (collection.ivImpl->CreateCursor ())
{
}

template <class Element, class ElementOps>
inline IGSortedSetAsBstTreeCursor <Element, ElementOps>&
IGSortedSetAsBstTreeCursor <Element, ElementOps>::
operator=
  (IGSortedSetAsBstTreeCursor
    <Element, ElementOps> const& cursor)
{ Inherited::operator= (cursor);
  return *this;
}

// protected members

template <class Element, class ElementOps>
inline
IGSortedSetAsBstTreeCursor <Element, ElementOps>::
IGSortedSetAsBstTreeCursor (ICursorImpl* impl)
: IOrderedCursor <Element> (impl)
{
}

// ---
// IGSortedSetAsBstTree
// ---

// public members

template <class Element, class ElementOps>
inline
IGSortedSetAsBstTree <Element, ElementOps>::
IGSortedSetAsBstTree (INumber numberOfElements)
{ SetImpl ((Implementation*) *new
                Instantiation (numberOfElements));
}

template <class Element, class ElementOps>
inline
IGSortedSetAsBstTree <Element, ElementOps>::
IGSortedSetAsBstTree
  (IGSortedSetAsBstTree
    <Element, ElementOps> const& collection)
{ CloneImplOf (collection);
}

template <class Element, class ElementOps>
inline IGSortedSetAsBstTree <Element, ElementOps>&
IGSortedSetAsBstTree <Element, ElementOps>::
operator= (IGSortedSetAsBstTree
            <Element, ElementOps> const& collection)
{ ImplOf (*this).Copy (ImplOf (collection));
  return *this;
}

// protected members

template <class Element, class ElementOps>
inline
IGSortedSetAsBstTree <Element, ElementOps>::
IGSortedSetAsBstTree (PureImplementation& impl)
{ SetImpl (&impl);
}

template <class Element, class ElementOps>
inline IGSortedSetAsBstTree
 <Element, ElementOps>::Implementation&
IGSortedSetAsBstTree <Element, ElementOps>::
ImplOf (IGSortedSetAsBstTree
         <Element, ElementOps> const& collection)
{ return *(Implementation*)collection.ivImpl;
}

// ---
// ISortedSetAsBstTree
// ---

// public members

template <class Element>
inline
ISortedSetAsBstTree <Element>::
ISortedSetAsBstTree (INumber numberOfElements)
: IGSortedSetAsBstTree
   <Element, ICOps <Element> > (numberOfElements)
{
}

// protected members

template <class Element>
inline
ISortedSetAsBstTree <Element>::
ISortedSetAsBstTree (PureImplementation& impl)
: IGSortedSetAsBstTree
   <Element, ICOps <Element> > (impl)
{
}

// ---
// IVGSortedSetAsBstTree
// ---

// public members

template <class Element, class ElementOps>
inline
IVGSortedSetAsBstTree <Element, ElementOps>::
IVGSortedSetAsBstTree (INumber numberOfElements)
: IGSortedSetAsBstTree
    <Element, ElementOps> (*(Implementation*) *new
                Instantiation (numberOfElements))
{
}

// protected members

template <class Element, class ElementOps>
inline
IVGSortedSetAsBstTree <Element, ElementOps>::
IVGSortedSetAsBstTree (PureImplementation& impl)
: IGSortedSetAsBstTree
    <Element, ElementOps> (impl)
{
}

// ---
// IVSortedSetAsBstTree
// ---

// public members

template <class Element>
inline
IVSortedSetAsBstTree <Element>::
IVSortedSetAsBstTree (INumber numberOfElements)
: IVGSortedSetAsBstTree
   <Element, ICOps <Element> > (numberOfElements)
{
}

// protected members

template <class Element>
inline
IVSortedSetAsBstTree <Element>::
IVSortedSetAsBstTree (PureImplementation& impl)
: IVGSortedSetAsBstTree
   <Element, ICOps <Element> > (impl)
{
}
