/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

// ---
// IGSortedSetAsDilTableCursor
// ---

// public members

template <class Element, class ElementOps>
inline
IGSortedSetAsDilTableCursor <Element, ElementOps>::
IGSortedSetAsDilTableCursor
  (IGSortedSetAsDilTable
    <Element, ElementOps> const& collection)
: IOrderedCursor <Element>
    (collection.ivImpl->CreateCursor ())
{
}

template <class Element, class ElementOps>
inline IGSortedSetAsDilTableCursor <Element, ElementOps>&
IGSortedSetAsDilTableCursor <Element, ElementOps>::
operator=
  (IGSortedSetAsDilTableCursor
    <Element, ElementOps> const& cursor)
{ Inherited::operator= (cursor);
  return *this;
}

// protected members

template <class Element, class ElementOps>
inline
IGSortedSetAsDilTableCursor <Element, ElementOps>::
IGSortedSetAsDilTableCursor (ICursorImpl* impl)
: IOrderedCursor <Element> (impl)
{
}

// ---
// IGSortedSetAsDilTable
// ---

// public members

template <class Element, class ElementOps>
inline
IGSortedSetAsDilTable <Element, ElementOps>::
IGSortedSetAsDilTable (INumber numberOfElements)
{ SetImpl ((Implementation*) *new
                Instantiation (numberOfElements));
}

template <class Element, class ElementOps>
inline
IGSortedSetAsDilTable <Element, ElementOps>::
IGSortedSetAsDilTable
  (IGSortedSetAsDilTable
    <Element, ElementOps> const& collection)
{ CloneImplOf (collection);
}

template <class Element, class ElementOps>
inline IGSortedSetAsDilTable <Element, ElementOps>&
IGSortedSetAsDilTable <Element, ElementOps>::
operator= (IGSortedSetAsDilTable
            <Element, ElementOps> const& collection)
{ ImplOf (*this).Copy (ImplOf (collection));
  return *this;
}

// protected members

template <class Element, class ElementOps>
inline
IGSortedSetAsDilTable <Element, ElementOps>::
IGSortedSetAsDilTable (PureImplementation& impl)
{ SetImpl (&impl);
}

template <class Element, class ElementOps>
inline IGSortedSetAsDilTable
 <Element, ElementOps>::Implementation&
IGSortedSetAsDilTable <Element, ElementOps>::
ImplOf (IGSortedSetAsDilTable
         <Element, ElementOps> const& collection)
{ return *(Implementation*)collection.ivImpl;
}

// ---
// ISortedSetAsDilTable
// ---

// public members

template <class Element>
inline
ISortedSetAsDilTable <Element>::
ISortedSetAsDilTable (INumber numberOfElements)
: IGSortedSetAsDilTable
   <Element, ICOps <Element> > (numberOfElements)
{
}

// protected members

template <class Element>
inline
ISortedSetAsDilTable <Element>::
ISortedSetAsDilTable (PureImplementation& impl)
: IGSortedSetAsDilTable
   <Element, ICOps <Element> > (impl)
{
}

// ---
// IVGSortedSetAsDilTable
// ---

// public members

template <class Element, class ElementOps>
inline
IVGSortedSetAsDilTable <Element, ElementOps>::
IVGSortedSetAsDilTable (INumber numberOfElements)
: IGSortedSetAsDilTable
    <Element, ElementOps> (*(Implementation*) *new
                Instantiation (numberOfElements))
{
}

// protected members

template <class Element, class ElementOps>
inline
IVGSortedSetAsDilTable <Element, ElementOps>::
IVGSortedSetAsDilTable (PureImplementation& impl)
: IGSortedSetAsDilTable
    <Element, ElementOps> (impl)
{
}

// ---
// IVSortedSetAsDilTable
// ---

// public members

template <class Element>
inline
IVSortedSetAsDilTable <Element>::
IVSortedSetAsDilTable (INumber numberOfElements)
: IVGSortedSetAsDilTable
   <Element, ICOps <Element> > (numberOfElements)
{
}

// protected members

template <class Element>
inline
IVSortedSetAsDilTable <Element>::
IVSortedSetAsDilTable (PureImplementation& impl)
: IVGSortedSetAsDilTable
   <Element, ICOps <Element> > (impl)
{
}
