/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _ISSLST_H
#define _ISSLST_H

#include <iass.h>
#include <iicss.h>
#include <iivss.h>
#include <iisslst.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Element, class ElementOps>
class IGSortedSetAsList;

template <class Element, class ElementOps>
class IGSortedSetAsListCursor :
  public IOrderedCursor <Element> {

  typedef  IOrderedCursor <Element> Inherited;

  typedef  IGSortedSetAsList
            <Element, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGSortedSetAsListCursor
                            (IGSortedSetAsList
                              <
                               Element, ElementOps> const&);

  IGSortedSetAsListCursor <Element, ElementOps>&
           operator=        (IGSortedSetAsListCursor
                              <
                               Element, ElementOps> const&);

protected:

           IGSortedSetAsListCursor
                            (ICursorImpl*);

private:


};

template <class Element, class ElementOps>
class IGSortedSetAsList :
  public IASortedSet <Element> {
protected:

  typedef  IGSortedSetAsList <Element, ElementOps> Self;

  typedef  ISortedSetAsListImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICSortedSetImpl
            <PureImplementation> Implementation;
#endif

#define IGSortedSetAsListTypedef(Element, ElementOps)\
  typedef  ISortedSetAsListOps\
            <Element,\
             IWCOps <Element, ElementOps>,\
             Implementation> Instantiation

           IGSortedSetAsListTypedef (Element, ElementOps);

public:

  typedef  IGSortedSetAsListCursor
            <Element, ElementOps> Cursor;


           IGSortedSetAsList
                            (INumber = 100);

           IGSortedSetAsList
                            (IGSortedSetAsList
                              <
                               Element, ElementOps> const&);

  IGSortedSetAsList <Element, ElementOps>&
           operator=        (IGSortedSetAsList
                              <
                               Element, ElementOps> const&);


protected:

           IGSortedSetAsList
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGSortedSetAsList
                              <
                               Element, ElementOps> const&);

private:

  friend
  class    IGSortedSetAsListCursor
            <Element, ElementOps>;



};

template <class Element>
class ISortedSetAsList :
  public IGSortedSetAsList
          <Element, ICOps <Element> > {

  typedef  IGSortedSetAsList
            <Element,
             ICOps <Element> > Inherited;

protected:

  typedef  ISortedSetAsList <Element> Self;

#define ISortedSetAsListTypedef(Element)\
  typedef  ISortedSetAsListOps\
            <Element,\
             IWCOps <Element, ICOps <Element> >,\
             Implementation> Instantiation

public:

           ISortedSetAsList
                            (INumber = 100);


protected:

           ISortedSetAsList
                              (PureImplementation&);

private:


};

template <class Element, class ElementOps>
class IVGSortedSetAsList :
  public IGSortedSetAsList
          <Element, ElementOps > {

  typedef  IVGSortedSetAsList
            <Element, ElementOps> Inherited;

protected:

#if defined (INO_CHECKS)
  typedef  IVSortedSetImpl
            <PureImplementation> Implementation;
#else
  typedef  ICSortedSetImpl
            <IVSortedSetImpl
              <PureImplementation> > Implementation;
#endif

#define IVGSortedSetAsListTypedef(Element, ElementOps)\
  typedef  ISortedSetAsListOps\
            <Element,\
             IWCOps <Element, ElementOps>,\
             Implementation> Instantiation

           IVGSortedSetAsListTypedef (Element, ElementOps);

public:

           IVGSortedSetAsList
                            (INumber = 100);


protected:

           IVGSortedSetAsList
                              (PureImplementation&);

private:


};

template <class Element>
class IVSortedSetAsList :
  public IVGSortedSetAsList
          <Element, ICOps <Element> > {

  typedef  IVGSortedSetAsList
            <Element,
             ICOps <Element> > Inherited;

protected:

  typedef  IVSortedSetAsList <Element> Self;

#define IVSortedSetAsListTypedef(Element)\
  typedef  IVSortedSetAsListOps\
            <Element,\
             IWCOps <Element, ICOps <Element> >,\
             Implementation> Instantiation

public:

           IVSortedSetAsList
                            (INumber = 100);


protected:

           IVSortedSetAsList
                              (PureImplementation&);

private:


};

#pragma SOMAsDefault (pop)

#include <isslst.inl>

#pragma info (restore)
#pragma pack ()

#endif
