/*******************************************************************************
* FILE NAME: istatnry.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IComponentStationery                                                     *
*     IComponentStationeryFor                                                  *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*   Portions or this component are based on work originating from Taligent.    *
*   (C) Copyright Taligent, Inc. 1996 - All rights reserved.                   *
*                                                                              *
*******************************************************************************/
#ifndef _ISTATNRY_
#define _ISTATNRY_

#include <imsgbox.hpp>

// forward references
class IModel;
class IView;
class IGUIBundle;
class IComponent;
class IComponentFactory;
class IComponentFrameWindow;
class CAswControl;
class IAswClipboardSource;
class IAswPasteTarget;
class IAswDragSource;
class CAswSourceFormatSet;
class CAswTargetFormatSet;

// classes defined in this module
class IComponentStationery;
template < class AModel, class AView > class IComponentStationeryFor;


#pragma pack(4)


typedef unsigned short CLIPFORMAT;

/*******************************************************************************
*                                                                              *
*   Class IComponentStationery                                                 *
*                                                                              *
*   Abstract base class for component stationeries                             *
*                                                                              *
*******************************************************************************/

class IComponentStationery : public IVBase
{

/*--------------------- Construction/Initialization --------------------------*/
protected:
                                    IComponentStationery();
public:
    virtual                         ~IComponentStationery();
    virtual Boolean                 initialize();
    int                             run( int argc, char* argv[] );

public:
// Public Methods

/*-------------------------- Global Objects ----------------------------------*/

    static IComponentStationery&    stationery();
    IGUIBundle&                     bundle()                const;


/*---------------------------- Environment -----------------------------------*/

    const IString&                  appName()               const;
    const IString&                  fileExt()               const;
    const IString&                  shortName()             const;
    Boolean                         isEmbedded()            const;
    Boolean                         isContainer()           const;
    Boolean                         isServer()              const;


/*--------------------------- Helper Methods ---------------------------------*/

    void                            enableBusyDialog( Boolean );
    void                            enableNotRespondingDialog( Boolean );
    void                            rejectInComingCalls();
    void                            allowInComingCalls();
    IMessageBox::Response           messageBox( const char* msg,
                                                const IMessageBox::Style& style=
                                                 IMessageBox::informationIcon |
                                                 IMessageBox::moveable        |
                                                 IMessageBox::applicationModal|
                                                 IMessageBox::okButton,
                                                IWindow*    owner=NULL);


/*----------------------------Factory Methods --------------------------------*/

    virtual IComponentFrameWindow*  createFrameWindow();
    virtual IGUIBundle*             createBundle() const;
    virtual IComponent*             createComponent() const;
    virtual IModel*                 createModel() const = 0;
    virtual IView*                  createView() const = 0;


/*--------------------------- Library Use Only -------------------------------*/
public:
#ifdef IC_LIBRARYUSEONLY
    // casting operator to make this class look like it was derived from CAswControl
                                    operator CAswControl* () const;

    // should really be protected but have to be called from winmain
    Boolean                         initWindows();
    Boolean                         setupBundle();
    // called in setup of compimp
    IComponentFactory&              componentFactory()      const;

/*----------------------------- Data Exchange --------------------------------*/
    IAswClipboardSource&            clipSource()            const;
    IAswPasteTarget&                pasteTarget()           const;
    IAswDragSource&                 dragSource()            const;
    CLIPFORMAT                      cfEmbeddedObject()      const;
    CLIPFORMAT                      cfObjectDescriptor()    const;
    CLIPFORMAT                      cfLinkSource()          const;
    CLIPFORMAT                      cfLinkSrcDescriptor()   const;
    CAswSourceFormatSet&            sourceFormatSet();
    CAswTargetFormatSet&            targetFormatSet();

#endif // IC_LIBRARYUSEONLY


private:
    void                            updateRegistry();
    CAswControl&                    control()               const;

private:
// Data members
    // our 1 and only instance
    static IComponentStationery*    fgTheStationery;

    CAswControl*                    fpAswControl;
    IComponentFactory*              fpComponentFactory;

    // In the future the stationery will maintain a list of bundle pointers
    // and support multi object servers.  Currently, servers are always
    // registered with OLE using REGCLS_SINGLEUSE.
    IGUIBundle*                     fpBundle;

    // clipboard and drag/drop support
    IAswClipboardSource*            fpClipSource;
    IAswPasteTarget*                fpPasteTarget;
    IAswDragSource*                 fpDragSource;
    CLIPFORMAT                      fcfEmbeddedObject;
    CLIPFORMAT                      fcfObjectDescriptor;
    CLIPFORMAT                      fcfLinkSource;
    CLIPFORMAT                      fcfLinkSrcDescriptor;

    CAswSourceFormatSet*            fpSourceFormatSet;
    CAswTargetFormatSet*            fpTargetFormatSet;

    // Running args
    IString                         fstrAppName;
    IString                         fstrFileExt;
    IString                         fstrShortName;

    // command line parsing
    Boolean                         fbEmbedded;


}; // class IComponentStationery



/*******************************************************************************
*                                                                              *
*   Class IComponentStationeryFor                                              *
*                                                                              *
*   Templated stationery class; takes a model and a view                       *
*                                                                              *
*******************************************************************************/

template < class AModel, class AView >
class IComponentStationeryFor : public IComponentStationery
{
public:
// Constuction/Destruction
                                    IComponentStationeryFor();
                                    ~IComponentStationeryFor();

// Public Methods

    // implementation of pure virtual methods in base class
    virtual IModel*                 createModel() const;
    virtual IView*                  createView() const;


}; // class IComponentStationeryFor



#ifndef __TEMPINC__
  #include <istatnry.c>
#endif

  #include <istatnry.inl>


#pragma pack()

#endif // _ISTATNRY_
