#ifndef _ISTDNTFY_
#define _ISTDNTFY_
/*******************************************************************************
* FILE NAME: istdntfy.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IStandardNotifier                                                        *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <inotify.hpp>
#include <iobslist.hpp>
#include <ievtdata.hpp>

class IObserverList;
class IObserver;
class INotificationEvent;

#pragma pack(4)

class IStandardNotifier : public INotifier {
typedef INotifier
  Inherited;

public:
/*---------------------------- Constructors ----------------------------------*/
  IStandardNotifier  ( );
  IStandardNotifier  ( const IStandardNotifier& copy );
IStandardNotifier
 &operator=          ( const IStandardNotifier& aStandardNotifier );

virtual
 ~IStandardNotifier  ( );

/*---------------------- Notification Members --------------------------------*/
virtual IStandardNotifier
 &enableNotification       ( Boolean enable = true ),
 &disableNotification      ( );

virtual Boolean
  isEnabledForNotification ( ) const;

/*---------------------------- Observer Notification -------------------------*/
virtual IStandardNotifier
 &notifyObservers          ( const INotificationEvent& anEvent );

/*----------------------- Notification Event Descriptions --------------------*/
static INotificationId const
  IC_IMPORTB deleteId;

protected:
/*-------------------------- Observer Addition and Removal -------------------*/
virtual IStandardNotifier
 &addObserver           ( IObserver&        observer,
                          const IEventData& userData = IEventData(0) ),
 &removeObserver        ( IObserver&  observer ),
 &removeAllObservers    ( );

virtual IObserverList
 &observerList          ( ) const;

/*---------------------------- Observer Notification -------------------------*/
virtual IStandardNotifier
  &notifyObservers      ( const INotificationId& nId );

private:
/*--------------------------------- Private ----------------------------------*/
IObserverList
  *observers;
Boolean
  enabled;
}; //IStandardNotifier

#pragma pack()

#endif /* _ISTDNTFY_ */
