/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _ISTK_H
#define _ISTK_H

#include <iastk.h>
#include <iicseq.h>
#include <iivseq.h>
#include <iiseqlst.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Element, class ElementOps>
class IGStack;

template <class Element, class ElementOps>
class IGStackCursor :
  public IOrderedCursor <Element> {

  typedef  IOrderedCursor <Element> Inherited;

  typedef  IGStack
            <Element, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGStackCursor
                            (IGStack
                              <
                               Element, ElementOps> const&);

  IGStackCursor <Element, ElementOps>&
           operator=        (IGStackCursor
                              <
                               Element, ElementOps> const&);

protected:

           IGStackCursor
                            (ICursorImpl*);

private:


};

template <class Element, class ElementOps>
class IGStack :
  public IAStack <Element> {
protected:

  typedef  IGStack <Element, ElementOps> Self;

  typedef  ISequenceAsListImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICSequenceImpl
            <PureImplementation> Implementation;
#endif

#define IGStackTypedef(Element, ElementOps)\
  typedef  ISequenceAsListOps\
            <Element,\
             IWStdOps <Element, ElementOps>,\
             Implementation> Instantiation

           IGStackTypedef (Element, ElementOps);

public:

  typedef  IGStackCursor
            <Element, ElementOps> Cursor;


           IGStack
                            (INumber = 100);

           IGStack
                            (IGStack
                              <
                               Element, ElementOps> const&);

  IGStack <Element, ElementOps>&
           operator=        (IGStack
                              <
                               Element, ElementOps> const&);


protected:

           IGStack
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGStack
                              <
                               Element, ElementOps> const&);

private:

  friend
  class    IGStackCursor
            <Element, ElementOps>;



};

template <class Element>
class IStack :
  public IGStack
          <Element, IStdOps <Element> > {

  typedef  IGStack
            <Element,
             IStdOps <Element> > Inherited;

protected:

  typedef  IStack <Element> Self;

#define IStackTypedef(Element)\
  typedef  ISequenceAsListOps\
            <Element,\
             IWStdOps <Element, IStdOps <Element> >,\
             Implementation> Instantiation

public:

           IStack
                            (INumber = 100);


protected:

           IStack
                              (PureImplementation&);

private:


};

template <class Element, class ElementOps>
class IVGStack :
  public IGStack
          <Element, ElementOps > {

  typedef  IVGStack
            <Element, ElementOps> Inherited;

protected:

#if defined (INO_CHECKS)
  typedef  IVSequenceImpl
            <PureImplementation> Implementation;
#else
  typedef  ICSequenceImpl
            <IVSequenceImpl
              <PureImplementation> > Implementation;
#endif

#define IVGStackTypedef(Element, ElementOps)\
  typedef  ISequenceAsListOps\
            <Element,\
             IWStdOps <Element, ElementOps>,\
             Implementation> Instantiation

           IVGStackTypedef (Element, ElementOps);

public:

           IVGStack
                            (INumber = 100);


protected:

           IVGStack
                              (PureImplementation&);

private:


};

template <class Element>
class IVStack :
  public IVGStack
          <Element, IStdOps <Element> > {

  typedef  IVGStack
            <Element,
             IStdOps <Element> > Inherited;

protected:

  typedef  IVStack <Element> Self;

#define IVStackTypedef(Element)\
  typedef  IVSequenceAsListOps\
            <Element,\
             IWStdOps <Element, IStdOps <Element> >,\
             Implementation> Instantiation

public:

           IVStack
                            (INumber = 100);


protected:

           IVStack
                              (PureImplementation&);

private:


};

#pragma SOMAsDefault (pop)

#include <istk.inl>

#pragma info (restore)
#pragma pack ()

#endif
