/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

// ---
// IGStackCursor
// ---

// public members

template <class Element, class ElementOps>
inline
IGStackCursor <Element, ElementOps>::
IGStackCursor
  (IGStack
    <Element, ElementOps> const& collection)
: IOrderedCursor <Element>
    (collection.ivImpl->CreateCursor ())
{
}

template <class Element, class ElementOps>
inline IGStackCursor <Element, ElementOps>&
IGStackCursor <Element, ElementOps>::
operator=
  (IGStackCursor
    <Element, ElementOps> const& cursor)
{ Inherited::operator= (cursor);
  return *this;
}

// protected members

template <class Element, class ElementOps>
inline
IGStackCursor <Element, ElementOps>::
IGStackCursor (ICursorImpl* impl)
: IOrderedCursor <Element> (impl)
{
}

// ---
// IGStack
// ---

// public members

template <class Element, class ElementOps>
inline
IGStack <Element, ElementOps>::
IGStack (INumber numberOfElements)
{ SetImpl ((Implementation*) *new
                Instantiation (numberOfElements));
}

template <class Element, class ElementOps>
inline
IGStack <Element, ElementOps>::
IGStack
  (IGStack
    <Element, ElementOps> const& collection)
{ CloneImplOf (collection);
}

template <class Element, class ElementOps>
inline IGStack <Element, ElementOps>&
IGStack <Element, ElementOps>::
operator= (IGStack
            <Element, ElementOps> const& collection)
{ ImplOf (*this).Copy (ImplOf (collection));
  return *this;
}

// protected members

template <class Element, class ElementOps>
inline
IGStack <Element, ElementOps>::
IGStack (PureImplementation& impl)
{ SetImpl (&impl);
}

template <class Element, class ElementOps>
inline IGStack
 <Element, ElementOps>::Implementation&
IGStack <Element, ElementOps>::
ImplOf (IGStack
         <Element, ElementOps> const& collection)
{ return *(Implementation*)collection.ivImpl;
}

// ---
// IStack
// ---

// public members

template <class Element>
inline
IStack <Element>::
IStack (INumber numberOfElements)
: IGStack
   <Element, IStdOps <Element> > (numberOfElements)
{
}

// protected members

template <class Element>
inline
IStack <Element>::
IStack (PureImplementation& impl)
: IGStack
   <Element, IStdOps <Element> > (impl)
{
}

// ---
// IVGStack
// ---

// public members

template <class Element, class ElementOps>
inline
IVGStack <Element, ElementOps>::
IVGStack (INumber numberOfElements)
: IGStack
    <Element, ElementOps> (*(Implementation*) *new
                Instantiation (numberOfElements))
{
}

// protected members

template <class Element, class ElementOps>
inline
IVGStack <Element, ElementOps>::
IVGStack (PureImplementation& impl)
: IGStack
    <Element, ElementOps> (impl)
{
}

// ---
// IVStack
// ---

// public members

template <class Element>
inline
IVStack <Element>::
IVStack (INumber numberOfElements)
: IVGStack
   <Element, IStdOps <Element> > (numberOfElements)
{
}

// protected members

template <class Element>
inline
IVStack <Element>::
IVStack (PureImplementation& impl)
: IVGStack
   <Element, IStdOps <Element> > (impl)
{
}
