/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _ISTKDIL_H
#define _ISTKDIL_H

#include <iastk.h>
#include <iicseq.h>
#include <iivseq.h>
#include <iiseqdil.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Element, class ElementOps>
class IGStackAsDilTable;

template <class Element, class ElementOps>
class IGStackAsDilTableCursor :
  public IOrderedCursor <Element> {

  typedef  IOrderedCursor <Element> Inherited;

  typedef  IGStackAsDilTable
            <Element, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGStackAsDilTableCursor
                            (IGStackAsDilTable
                              <
                               Element, ElementOps> const&);

  IGStackAsDilTableCursor <Element, ElementOps>&
           operator=        (IGStackAsDilTableCursor
                              <
                               Element, ElementOps> const&);

protected:

           IGStackAsDilTableCursor
                            (ICursorImpl*);

private:


};

template <class Element, class ElementOps>
class IGStackAsDilTable :
  public IAStack <Element> {
protected:

  typedef  IGStackAsDilTable <Element, ElementOps> Self;

  typedef  ISequenceAsDilTableImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICSequenceImpl
            <PureImplementation> Implementation;
#endif

#define IGStackAsDilTableTypedef(Element, ElementOps)\
  typedef  ISequenceAsDilTableOps\
            <Element,\
             IWStdOps <Element, ElementOps>,\
             Implementation> Instantiation

           IGStackAsDilTableTypedef (Element, ElementOps);

public:

  typedef  IGStackAsDilTableCursor
            <Element, ElementOps> Cursor;


           IGStackAsDilTable
                            (INumber = 100);

           IGStackAsDilTable
                            (IGStackAsDilTable
                              <
                               Element, ElementOps> const&);

  IGStackAsDilTable <Element, ElementOps>&
           operator=        (IGStackAsDilTable
                              <
                               Element, ElementOps> const&);


protected:

           IGStackAsDilTable
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGStackAsDilTable
                              <
                               Element, ElementOps> const&);

private:

  friend
  class    IGStackAsDilTableCursor
            <Element, ElementOps>;



};

template <class Element>
class IStackAsDilTable :
  public IGStackAsDilTable
          <Element, IStdOps <Element> > {

  typedef  IGStackAsDilTable
            <Element,
             IStdOps <Element> > Inherited;

protected:

  typedef  IStackAsDilTable <Element> Self;

#define IStackAsDilTableTypedef(Element)\
  typedef  ISequenceAsDilTableOps\
            <Element,\
             IWStdOps <Element, IStdOps <Element> >,\
             Implementation> Instantiation

public:

           IStackAsDilTable
                            (INumber = 100);


protected:

           IStackAsDilTable
                              (PureImplementation&);

private:


};

template <class Element, class ElementOps>
class IVGStackAsDilTable :
  public IGStackAsDilTable
          <Element, ElementOps > {

  typedef  IVGStackAsDilTable
            <Element, ElementOps> Inherited;

protected:

#if defined (INO_CHECKS)
  typedef  IVSequenceImpl
            <PureImplementation> Implementation;
#else
  typedef  ICSequenceImpl
            <IVSequenceImpl
              <PureImplementation> > Implementation;
#endif

#define IVGStackAsDilTableTypedef(Element, ElementOps)\
  typedef  ISequenceAsDilTableOps\
            <Element,\
             IWStdOps <Element, ElementOps>,\
             Implementation> Instantiation

           IVGStackAsDilTableTypedef (Element, ElementOps);

public:

           IVGStackAsDilTable
                            (INumber = 100);


protected:

           IVGStackAsDilTable
                              (PureImplementation&);

private:


};

template <class Element>
class IVStackAsDilTable :
  public IVGStackAsDilTable
          <Element, IStdOps <Element> > {

  typedef  IVGStackAsDilTable
            <Element,
             IStdOps <Element> > Inherited;

protected:

  typedef  IVStackAsDilTable <Element> Self;

#define IVStackAsDilTableTypedef(Element)\
  typedef  IVSequenceAsDilTableOps\
            <Element,\
             IWStdOps <Element, IStdOps <Element> >,\
             Implementation> Instantiation

public:

           IVStackAsDilTable
                            (INumber = 100);


protected:

           IVStackAsDilTable
                              (PureImplementation&);

private:


};

#pragma SOMAsDefault (pop)

#include <istkdil.inl>

#pragma info (restore)
#pragma pack ()

#endif
