/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

// ---
// IGStackAsDilTableCursor
// ---

// public members

template <class Element, class ElementOps>
inline
IGStackAsDilTableCursor <Element, ElementOps>::
IGStackAsDilTableCursor
  (IGStackAsDilTable
    <Element, ElementOps> const& collection)
: IOrderedCursor <Element>
    (collection.ivImpl->CreateCursor ())
{
}

template <class Element, class ElementOps>
inline IGStackAsDilTableCursor <Element, ElementOps>&
IGStackAsDilTableCursor <Element, ElementOps>::
operator=
  (IGStackAsDilTableCursor
    <Element, ElementOps> const& cursor)
{ Inherited::operator= (cursor);
  return *this;
}

// protected members

template <class Element, class ElementOps>
inline
IGStackAsDilTableCursor <Element, ElementOps>::
IGStackAsDilTableCursor (ICursorImpl* impl)
: IOrderedCursor <Element> (impl)
{
}

// ---
// IGStackAsDilTable
// ---

// public members

template <class Element, class ElementOps>
inline
IGStackAsDilTable <Element, ElementOps>::
IGStackAsDilTable (INumber numberOfElements)
{ SetImpl ((Implementation*) *new
                Instantiation (numberOfElements));
}

template <class Element, class ElementOps>
inline
IGStackAsDilTable <Element, ElementOps>::
IGStackAsDilTable
  (IGStackAsDilTable
    <Element, ElementOps> const& collection)
{ CloneImplOf (collection);
}

template <class Element, class ElementOps>
inline IGStackAsDilTable <Element, ElementOps>&
IGStackAsDilTable <Element, ElementOps>::
operator= (IGStackAsDilTable
            <Element, ElementOps> const& collection)
{ ImplOf (*this).Copy (ImplOf (collection));
  return *this;
}

// protected members

template <class Element, class ElementOps>
inline
IGStackAsDilTable <Element, ElementOps>::
IGStackAsDilTable (PureImplementation& impl)
{ SetImpl (&impl);
}

template <class Element, class ElementOps>
inline IGStackAsDilTable
 <Element, ElementOps>::Implementation&
IGStackAsDilTable <Element, ElementOps>::
ImplOf (IGStackAsDilTable
         <Element, ElementOps> const& collection)
{ return *(Implementation*)collection.ivImpl;
}

// ---
// IStackAsDilTable
// ---

// public members

template <class Element>
inline
IStackAsDilTable <Element>::
IStackAsDilTable (INumber numberOfElements)
: IGStackAsDilTable
   <Element, IStdOps <Element> > (numberOfElements)
{
}

// protected members

template <class Element>
inline
IStackAsDilTable <Element>::
IStackAsDilTable (PureImplementation& impl)
: IGStackAsDilTable
   <Element, IStdOps <Element> > (impl)
{
}

// ---
// IVGStackAsDilTable
// ---

// public members

template <class Element, class ElementOps>
inline
IVGStackAsDilTable <Element, ElementOps>::
IVGStackAsDilTable (INumber numberOfElements)
: IGStackAsDilTable
    <Element, ElementOps> (*(Implementation*) *new
                Instantiation (numberOfElements))
{
}

// protected members

template <class Element, class ElementOps>
inline
IVGStackAsDilTable <Element, ElementOps>::
IVGStackAsDilTable (PureImplementation& impl)
: IGStackAsDilTable
    <Element, ElementOps> (impl)
{
}

// ---
// IVStackAsDilTable
// ---

// public members

template <class Element>
inline
IVStackAsDilTable <Element>::
IVStackAsDilTable (INumber numberOfElements)
: IVGStackAsDilTable
   <Element, IStdOps <Element> > (numberOfElements)
{
}

// protected members

template <class Element>
inline
IVStackAsDilTable <Element>::
IVStackAsDilTable (PureImplementation& impl)
: IVGStackAsDilTable
   <Element, IStdOps <Element> > (impl)
{
}
