/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _ISTKLST_H
#define _ISTKLST_H

#include <iastk.h>
#include <iicseq.h>
#include <iivseq.h>
#include <iiseqlst.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Element, class ElementOps>
class IGStackAsList;

template <class Element, class ElementOps>
class IGStackAsListCursor :
  public IOrderedCursor <Element> {

  typedef  IOrderedCursor <Element> Inherited;

  typedef  IGStackAsList
            <Element, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGStackAsListCursor
                            (IGStackAsList
                              <
                               Element, ElementOps> const&);

  IGStackAsListCursor <Element, ElementOps>&
           operator=        (IGStackAsListCursor
                              <
                               Element, ElementOps> const&);

protected:

           IGStackAsListCursor
                            (ICursorImpl*);

private:


};

template <class Element, class ElementOps>
class IGStackAsList :
  public IAStack <Element> {
protected:

  typedef  IGStackAsList <Element, ElementOps> Self;

  typedef  ISequenceAsListImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICSequenceImpl
            <PureImplementation> Implementation;
#endif

#define IGStackAsListTypedef(Element, ElementOps)\
  typedef  ISequenceAsListOps\
            <Element,\
             IWStdOps <Element, ElementOps>,\
             Implementation> Instantiation

           IGStackAsListTypedef (Element, ElementOps);

public:

  typedef  IGStackAsListCursor
            <Element, ElementOps> Cursor;


           IGStackAsList
                            (INumber = 100);

           IGStackAsList
                            (IGStackAsList
                              <
                               Element, ElementOps> const&);

  IGStackAsList <Element, ElementOps>&
           operator=        (IGStackAsList
                              <
                               Element, ElementOps> const&);


protected:

           IGStackAsList
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGStackAsList
                              <
                               Element, ElementOps> const&);

private:

  friend
  class    IGStackAsListCursor
            <Element, ElementOps>;



};

template <class Element>
class IStackAsList :
  public IGStackAsList
          <Element, IStdOps <Element> > {

  typedef  IGStackAsList
            <Element,
             IStdOps <Element> > Inherited;

protected:

  typedef  IStackAsList <Element> Self;

#define IStackAsListTypedef(Element)\
  typedef  ISequenceAsListOps\
            <Element,\
             IWStdOps <Element, IStdOps <Element> >,\
             Implementation> Instantiation

public:

           IStackAsList
                            (INumber = 100);


protected:

           IStackAsList
                              (PureImplementation&);

private:


};

template <class Element, class ElementOps>
class IVGStackAsList :
  public IGStackAsList
          <Element, ElementOps > {

  typedef  IVGStackAsList
            <Element, ElementOps> Inherited;

protected:

#if defined (INO_CHECKS)
  typedef  IVSequenceImpl
            <PureImplementation> Implementation;
#else
  typedef  ICSequenceImpl
            <IVSequenceImpl
              <PureImplementation> > Implementation;
#endif

#define IVGStackAsListTypedef(Element, ElementOps)\
  typedef  ISequenceAsListOps\
            <Element,\
             IWStdOps <Element, ElementOps>,\
             Implementation> Instantiation

           IVGStackAsListTypedef (Element, ElementOps);

public:

           IVGStackAsList
                            (INumber = 100);


protected:

           IVGStackAsList
                              (PureImplementation&);

private:


};

template <class Element>
class IVStackAsList :
  public IVGStackAsList
          <Element, IStdOps <Element> > {

  typedef  IVGStackAsList
            <Element,
             IStdOps <Element> > Inherited;

protected:

  typedef  IVStackAsList <Element> Self;

#define IVStackAsListTypedef(Element)\
  typedef  IVSequenceAsListOps\
            <Element,\
             IWStdOps <Element, IStdOps <Element> >,\
             Implementation> Instantiation

public:

           IVStackAsList
                            (INumber = 100);


protected:

           IVStackAsList
                              (PureImplementation&);

private:


};

#pragma SOMAsDefault (pop)

#include <istklst.inl>

#pragma info (restore)
#pragma pack ()

#endif
