/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

// ---
// IGStackAsListCursor
// ---

// public members

template <class Element, class ElementOps>
inline
IGStackAsListCursor <Element, ElementOps>::
IGStackAsListCursor
  (IGStackAsList
    <Element, ElementOps> const& collection)
: IOrderedCursor <Element>
    (collection.ivImpl->CreateCursor ())
{
}

template <class Element, class ElementOps>
inline IGStackAsListCursor <Element, ElementOps>&
IGStackAsListCursor <Element, ElementOps>::
operator=
  (IGStackAsListCursor
    <Element, ElementOps> const& cursor)
{ Inherited::operator= (cursor);
  return *this;
}

// protected members

template <class Element, class ElementOps>
inline
IGStackAsListCursor <Element, ElementOps>::
IGStackAsListCursor (ICursorImpl* impl)
: IOrderedCursor <Element> (impl)
{
}

// ---
// IGStackAsList
// ---

// public members

template <class Element, class ElementOps>
inline
IGStackAsList <Element, ElementOps>::
IGStackAsList (INumber numberOfElements)
{ SetImpl ((Implementation*) *new
                Instantiation (numberOfElements));
}

template <class Element, class ElementOps>
inline
IGStackAsList <Element, ElementOps>::
IGStackAsList
  (IGStackAsList
    <Element, ElementOps> const& collection)
{ CloneImplOf (collection);
}

template <class Element, class ElementOps>
inline IGStackAsList <Element, ElementOps>&
IGStackAsList <Element, ElementOps>::
operator= (IGStackAsList
            <Element, ElementOps> const& collection)
{ ImplOf (*this).Copy (ImplOf (collection));
  return *this;
}

// protected members

template <class Element, class ElementOps>
inline
IGStackAsList <Element, ElementOps>::
IGStackAsList (PureImplementation& impl)
{ SetImpl (&impl);
}

template <class Element, class ElementOps>
inline IGStackAsList
 <Element, ElementOps>::Implementation&
IGStackAsList <Element, ElementOps>::
ImplOf (IGStackAsList
         <Element, ElementOps> const& collection)
{ return *(Implementation*)collection.ivImpl;
}

// ---
// IStackAsList
// ---

// public members

template <class Element>
inline
IStackAsList <Element>::
IStackAsList (INumber numberOfElements)
: IGStackAsList
   <Element, IStdOps <Element> > (numberOfElements)
{
}

// protected members

template <class Element>
inline
IStackAsList <Element>::
IStackAsList (PureImplementation& impl)
: IGStackAsList
   <Element, IStdOps <Element> > (impl)
{
}

// ---
// IVGStackAsList
// ---

// public members

template <class Element, class ElementOps>
inline
IVGStackAsList <Element, ElementOps>::
IVGStackAsList (INumber numberOfElements)
: IGStackAsList
    <Element, ElementOps> (*(Implementation*) *new
                Instantiation (numberOfElements))
{
}

// protected members

template <class Element, class ElementOps>
inline
IVGStackAsList <Element, ElementOps>::
IVGStackAsList (PureImplementation& impl)
: IGStackAsList
    <Element, ElementOps> (impl)
{
}

// ---
// IVStackAsList
// ---

// public members

template <class Element>
inline
IVStackAsList <Element>::
IVStackAsList (INumber numberOfElements)
: IVGStackAsList
   <Element, IStdOps <Element> > (numberOfElements)
{
}

// protected members

template <class Element>
inline
IVStackAsList <Element>::
IVStackAsList (PureImplementation& impl)
: IVGStackAsList
   <Element, IStdOps <Element> > (impl)
{
}
