/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _ISTKTAB_H
#define _ISTKTAB_H

#include <iastk.h>
#include <iicseq.h>
#include <iivseq.h>
#include <iiseqtab.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Element, class ElementOps>
class IGStackAsTable;

template <class Element, class ElementOps>
class IGStackAsTableCursor :
  public IOrderedCursor <Element> {

  typedef  IOrderedCursor <Element> Inherited;

  typedef  IGStackAsTable
            <Element, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGStackAsTableCursor
                            (IGStackAsTable
                              <
                               Element, ElementOps> const&);

  IGStackAsTableCursor <Element, ElementOps>&
           operator=        (IGStackAsTableCursor
                              <
                               Element, ElementOps> const&);

protected:

           IGStackAsTableCursor
                            (ICursorImpl*);

private:


};

template <class Element, class ElementOps>
class IGStackAsTable :
  public IAStack <Element> {
protected:

  typedef  IGStackAsTable <Element, ElementOps> Self;

  typedef  ISequenceAsTableImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICSequenceImpl
            <PureImplementation> Implementation;
#endif

#define IGStackAsTableTypedef(Element, ElementOps)\
  typedef  ISequenceAsTableOps\
            <Element,\
             IWStdOps <Element, ElementOps>,\
             Implementation> Instantiation

           IGStackAsTableTypedef (Element, ElementOps);

public:

  typedef  IGStackAsTableCursor
            <Element, ElementOps> Cursor;


           IGStackAsTable
                            (INumber = 100);

           IGStackAsTable
                            (IGStackAsTable
                              <
                               Element, ElementOps> const&);

  IGStackAsTable <Element, ElementOps>&
           operator=        (IGStackAsTable
                              <
                               Element, ElementOps> const&);


protected:

           IGStackAsTable
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGStackAsTable
                              <
                               Element, ElementOps> const&);

private:

  friend
  class    IGStackAsTableCursor
            <Element, ElementOps>;



};

template <class Element>
class IStackAsTable :
  public IGStackAsTable
          <Element, IStdOps <Element> > {

  typedef  IGStackAsTable
            <Element,
             IStdOps <Element> > Inherited;

protected:

  typedef  IStackAsTable <Element> Self;

#define IStackAsTableTypedef(Element)\
  typedef  ISequenceAsTableOps\
            <Element,\
             IWStdOps <Element, IStdOps <Element> >,\
             Implementation> Instantiation

public:

           IStackAsTable
                            (INumber = 100);


protected:

           IStackAsTable
                              (PureImplementation&);

private:


};

template <class Element, class ElementOps>
class IVGStackAsTable :
  public IGStackAsTable
          <Element, ElementOps > {

  typedef  IVGStackAsTable
            <Element, ElementOps> Inherited;

protected:

#if defined (INO_CHECKS)
  typedef  IVSequenceImpl
            <PureImplementation> Implementation;
#else
  typedef  ICSequenceImpl
            <IVSequenceImpl
              <PureImplementation> > Implementation;
#endif

#define IVGStackAsTableTypedef(Element, ElementOps)\
  typedef  ISequenceAsTableOps\
            <Element,\
             IWStdOps <Element, ElementOps>,\
             Implementation> Instantiation

           IVGStackAsTableTypedef (Element, ElementOps);

public:

           IVGStackAsTable
                            (INumber = 100);


protected:

           IVGStackAsTable
                              (PureImplementation&);

private:


};

template <class Element>
class IVStackAsTable :
  public IVGStackAsTable
          <Element, IStdOps <Element> > {

  typedef  IVGStackAsTable
            <Element,
             IStdOps <Element> > Inherited;

protected:

  typedef  IVStackAsTable <Element> Self;

#define IVStackAsTableTypedef(Element)\
  typedef  IVSequenceAsTableOps\
            <Element,\
             IWStdOps <Element, IStdOps <Element> >,\
             Implementation> Instantiation

public:

           IVStackAsTable
                            (INumber = 100);


protected:

           IVStackAsTable
                              (PureImplementation&);

private:


};

#pragma SOMAsDefault (pop)

#include <istktab.inl>

#pragma info (restore)
#pragma pack ()

#endif
