
#ifndef _ISTRTEST_
#define _ISTRTEST_
/*******************************************************************************
* FILE NAME: istrtest.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IStringTest                                                              *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <ivbase.hpp>

#pragma pack(4)

extern "C"
  {
  typedef IBase::Boolean ICStrTestFn( int );
  }



class IStringTest : public IVBase {
typedef IVBase
  Inherited;

public:

/*------------------------- Function Types -----------------------------------*/
typedef ICStrTestFn
  CFunction;
typedef Boolean
  CPPFunction( int );

/*------------------------- Constructors -------------------------------------*/
  IStringTest ( CFunction   &cFunc );
 ~IStringTest ( );

/*------------------------- Testing ------------------------------------------*/
virtual Boolean
  test        ( int c ) const;

protected:
/*------------------------- Test Function Description ------------------------*/
enum FnType {
  user,
  c,
  cpp,
  memFn,
  cMemFn
  };

FnType
  type;

union { CFunction *cFn; void *user; } data;

/*------------------------ Protected Constructors ----------------------------*/
  IStringTest ( FnType  type,
                void   *userData );

}; // class IStringTest

template < class T >
class IStringTestMemberFn : public IStringTest {
public:
/*------------------------- Function Types -----------------------------------*/
typedef Boolean
 ( T::*ConstFn )( int ) const;
typedef Boolean
 ( T::*NonconstFn )( int );

/*------------------------- Constructors -------------------------------------*/
  IStringTestMemberFn ( const T    &object,
                        ConstFn     constFn )
    : IStringTest ( user, (void*)&object ),
      cMF         ( constFn )
    {
    }
  IStringTestMemberFn ( T          &object,
                        NonconstFn  nonconstFn )
    : IStringTest ( user, (void*)&object ),
      ncMF        ( nonconstFn )
    {
    }

/*------------------------- Testing ------------------------------------------*/
virtual Boolean
  test                ( int c ) const
    {
    if ( this->type == cMemFn )
      return ((const T*)data.user->*cMF)( c );
    else
      return ((T*)data.user->*ncMF)( c );
    }

private:
/*------------------------------ Private ------------------------------------*/
union { ConstFn cMF; NonconstFn ncMF; };



};



#pragma pack()

  #include <istrtest.inl>

#endif // _ISTRTEST_



