#ifndef _ISYNONYM_
#define _ISYNONYM_
/*******************************************************************************
* FILE NAME: isynonym.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   This file declares synonyms for the types and values nested within         *
*   class IBase (see <ibase.hpp>).  #include-ing this file results in those    *
*   names being placed in the global name space, permitting consistent usage   *
*   in IBase derived classes and client code.                                  *
*                                                                              *
*   If these global names conflict with other usage of these names within      *
*   a client application, then this file should be modified for use in such    *
*   application.  For example, if you are using another library which          *
*   utilizes the typedef Boolean, then change "Boolean" below to something     *
*   like "IBoolean." "IBoolean" would then be used throughout your             *
*   application.                                                               *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/

#ifndef _BooleanType
   #define _BooleanType

typedef int Boolean;

#endif

typedef int IBoolean;

#ifndef _BooleanConst
   #define _BooleanConst

   enum {
      false = 0,
      False = 0,
      true  = 1,
      True  = 1
   };

#endif

#endif /* _ISYNONYM_ */
