#ifndef _ISYSMENU_
#define _ISYSMENU_
/*******************************************************************************
* FILE NAME: isysmenu.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the class:                                                  *
*     ISystemMenu                                                              *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <imenu.hpp>

class IFrameWindow;
class ISystemMenuData;

#pragma pack(4)

class ISystemMenu : public IMenu {
typedef IMenu
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  ISystemMenu ( IFrameWindow* owner );
virtual
 ~ISystemMenu ( );

/*----------------------------- Item Identifiers -----------------------------*/
static const unsigned long
  IC_IMPORTU idPulldown,
  IC_IMPORTU idRestore,
  IC_IMPORTU idMove,
  IC_IMPORTU idSize,
  IC_IMPORTU idMinimize,
  IC_IMPORTU idMaximize,
  IC_IMPORTU idHide,
  IC_IMPORTU idWindowList;

static const unsigned long
  IC_IMPORTU idClose;

private:
/*------------------------------ Hidden Members ------------------------------*/
  ISystemMenu ( const ISystemMenu& menu );
ISystemMenu
 &operator=   ( const ISystemMenu& menu );

/*--------------------------------- Private ----------------------------------*/
ISystemMenuData
 *fSystemMenuData;

}; // ISystemMenu

#pragma pack()

#endif  /* _ISYSMENU_ */
