#ifndef _ITBAR_
#define _ITBAR_

/*******************************************************************************
* FILE NAME: itbar.hpp                                                         *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IToolBar                                                                 *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <isetcv.hpp>
#include <irect.hpp>
#include <itbarbut.hpp>

class ISize;
class IPoint;
class IString;
class IFrameWindow;
class IResourceId;
class IToolBarData;
class IToolBarContainer;
class IToolBarFrameWindow;
class IToolBarFrameCursorData;
class IToolBarWindowCursorData;

#pragma pack(4)


class IToolBar : public ISetCanvas {
typedef ISetCanvas
  Inherited;

public:
class Style;
/*---------------------------- Tool Bar Location -----------------------------*/
enum Location {
  aboveClient,
  belowClient,
  leftOfClient,
  rightOfClient,
  floating,
  hidden
};

virtual IToolBar
 &setLocation ( Location location );

Location
  location    ( ) const;

/*------------------------------ Constructors --------------------------------*/
  IToolBar ( unsigned long          identifier,
             IFrameWindow*          owner,
             Location               location = aboveClient,
             Boolean                groupWithPreceding = false,
             const Style&           style=defaultStyle());
  IToolBar ( unsigned long          identifier,
             IToolBar*              precedingToolBar,
             Boolean                groupWithPreceding = false,
             const Style&           style=defaultStyle());

virtual
  ~IToolBar ( );

/*------------------------------ Style ---------------------------------------*/
INESTEDBITFLAGCLASSDEF3(Style, IToolBar, ISetCanvas, ICanvas, IWindow);

static const Style
  IC_IMPORTU buttonBitmapVisible,
  IC_IMPORTU buttonTextVisible,
  IC_IMPORTU buttonBitmapAndTextVisible,
  IC_IMPORTU filterMisfits,
  IC_IMPORTU noDragDrop,
  IC_IMPORTU classDefaultStyle;

static Style
  defaultStyle      ( );

static void
  setDefaultStyle   ( const Style&    style );

virtual unsigned long
  convertToGUIStyle ( const IBitFlag& style,
                      Boolean         extendedOnly = false ) const;

/*------------------------- Tool Bar Contents --------------------------------*/
virtual IToolBar
 &addAsFirst        ( IWindow*      window,
                      Boolean       startNewGroup = false ),
 &addAsNext         ( IWindow*      window,
                      IWindow*      referenceWindow,
                      Boolean       startNewGroup = false ),
 &addAsPrevious     ( IWindow*      window,
                      IWindow*      referenceWindow,
                      Boolean       startNewGroup = false ),
 &addAsLast         ( IWindow*      window,
                      Boolean       startNewGroup = false ),
 &moveToFirst       ( IWindow*      window,
                      Boolean       startNewGroup = false ),
 &moveAfter         ( IWindow*      window,
                      IWindow*      referenceWindow,
                      Boolean       startNewGroup = false ),
 &moveBefore        ( IWindow*      window,
                      IWindow*      referenceWindow,
                      Boolean       startNewGroup = false ),
 &moveToLast        ( IWindow*      window,
                      Boolean       startNewGroup = false ),
 &remove            ( IWindow*      window );

/*----------------------- Tool Bar Button Behavior  --------------------------*/
virtual IToolBar
 &setButtonView  ( IToolBarButton::View buttonView );

IToolBarButton::View
  buttonView      ( ) const;

/*------------------------------ Filter Misfits ------------------------------*/
IToolBar
 &enableMisfitFiltering  ( Boolean enable = true ),
 &disableMisfitFiltering ( );

Boolean
  isMisfitFilteringEnabled ( ) const;

/*----------------------- Floating Tool Bar ----------------------------------*/
virtual IToolBar
 &setFloatingPosition ( const IPoint& frameRelativePosition );

IPoint
  floatingPosition ( ) const;

virtual IToolBar
 &setFloatingTitle   ( const char* text ),
 &setFloatingTitle   ( const IResourceId& text );

IString
  floatingTitle      ( ) const;

virtual IToolBarFrameWindow
 *floatingFrame       ( );

/*----------------------- Tool Bar Defaults ----------------------------------*/
static void
  setDefaultPad         ( long           pixelsOfPad      = -1 ),
  setDefaultMargin      ( const ISize&   sizeOfMargin     = ISize(7,4)),
  setDefaultGroupPad    ( unsigned long  pixelsOfGroupPad = 8 ),
  setDefaultMisfitWidth ( unsigned long  maximumWidth     = 100 );

static long
  defaultPad            ( );

static ISize
  defaultMargin         ( );

static unsigned long
  defaultGroupPad       ( ),
  defaultMisfitWidth    ( );

/*------------------------------ Tool Bar Container --------------------------*/
virtual IToolBarContainer
 *toolBarContainer       ( ) const;

/*----------------------------- Canvas Layout --------------------------------*/
virtual IToolBar
 &setLayoutDistorted ( unsigned long layoutAttributeOn,
                       unsigned long layoutAttributeOff );

/*--------------------- Expanding/Collapsing the ToolBar ---------------------*/
virtual IToolBar
 &expand   ( Boolean expand = true ),
 &collapse ( );

Boolean
  isExpanded ( ) const;

/*------------------------------- Drag Drop Support --------------------------*/
virtual IToolBar
 &enableDragDrop  ( Boolean enable = true ),
 &disableDragDrop ( );

Boolean
  allowsDragDrop  ( ) const;


class FrameCursor : public IVBase {
typedef IVBase
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  FrameCursor ( const IFrameWindow* frame );
virtual
 ~FrameCursor ( );

/*----------------------------- Cursor Functions -----------------------------*/
virtual Boolean
  setToFirst ( ),
  setToNext  ( ),
  isValid    ( ) const;

virtual void
  invalidate ( );

private:
friend class IToolBar;
IToolBarFrameCursorData
  *fToolBarFrameCursorData;
};

class WindowCursor : public IVBase {
typedef IVBase
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  WindowCursor ( const IToolBar* toolbar );
virtual
 ~WindowCursor ( );

/*----------------------------- Cursor Functions -----------------------------*/
virtual Boolean
  setToFirst ( ),
  setToNext  ( ),
  isValid    ( ) const;

virtual void
  invalidate ( );

private:
friend class IToolBar;
IToolBarWindowCursorData
  *fToolBarWindowCursorData;
};

/*----------------------------- Cursor Functions -----------------------------*/
static IToolBar
  *toolBarAt ( const FrameCursor& cursor );

IWindow
  *windowAt ( const WindowCursor& cursor ) const;

protected:
/*------------------------------ Initialization ------------------------------*/
virtual IToolBar
 &initialize       ( );

virtual IToolBarContainer
 *createToolBarContainer ( IFrameWindow* frame );

virtual IToolBarFrameWindow
 *createFloatingFrame    ( IFrameWindow* owner );

virtual IToolBar
  &filter ( );

/*---------------------------------- Layout ----------------------------------*/
virtual ISize
  calcMinimumSize    ( ) const;

/*-------------------------------- Private -----------------------------------*/
private:
IToolBar            ( const IToolBar& );
IToolBar& operator= ( const IToolBar& );

void addControl ( IControl* control,
                  Boolean   newGroup );

friend class IToolBarContainer;
friend class IToolBarPaintHandler;
friend class IToolBar::WindowCursor;

static Style
  fgCurrentDefaultStyle;

IToolBarData
 *fToolBarData;
};

// global style functions
INESTEDBITFLAGCLASSFUNCS(Style, IToolBar);


#pragma pack()

#endif /* _ITBAR_ */

