#ifndef _ITBARBUT_
#define _ITBARBUT_
/*******************************************************************************
* FILE NAME: itbarbut.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IToolBarButton                                                           *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <icustbut.hpp>
#include <irect.hpp>
#include <ipoint.hpp>
#include <icolor.hpp>

class IBitmapHandle;
class IResourceId;
class IToolBarButtonData;

#pragma pack(4)


class IToolBarButton : public ICustomButton {
typedef ICustomButton
  Inherited;
public:
class Style;
/*----------------------------- Constructors ---------------------------------*/
  IToolBarButton  ( unsigned long     id,
                    IWindow*          parent,
                    IWindow*          owner,
                    const IRectangle& initial = IRectangle(),
                    const Style&      style = defaultStyle() );

virtual
  ~IToolBarButton ( );


/*------------------------------- Styles -------------------------------------*/
INESTEDBITFLAGCLASSDEF4(Style, IToolBarButton, IWindow,
                        IControl, IButton, ICustomButton);
                                  // style class definition
static const Style
  IC_IMPORTU bitmapVisible,
  IC_IMPORTU textVisible,
  IC_IMPORTU bitmapAndTextVisible,
  IC_IMPORTU useIdForBitmap,
  IC_IMPORTU useIdForText,
  IC_IMPORTU standardFormat,
  IC_IMPORTU noDragDelete,
  IC_IMPORTU classDefaultStyle;

static Style
  defaultStyle      ( );

static void
  setDefaultStyle   ( const Style&    style );

virtual unsigned long
  convertToGUIStyle ( const IBitFlag& style,
                      Boolean         extendedOnly = false ) const;

/*------------------------------ Bitmaps -------------------------------------*/
virtual IToolBarButton
  &setBitmap        ( const IResourceId&   bitmapId ),
  &setBitmap        ( const IBitmapHandle& handle ),
  &setBitmap        ( unsigned long        id ),
  &setLatchedBitmap ( const IResourceId&   latchedBitmapId ),
  &setLatchedBitmap ( const IBitmapHandle& handle ),
  &setLatchedBitmap ( unsigned long        id );

IBitmapHandle
  bitmap            ( ) const,
  latchedBitmap     ( ) const;

virtual ISize
  bitmapSize        ( ) const;

/*-------------------------------- Views -------------------------------------*/
enum View {
  bitmapView,
  textView,
  bitmapAndTextView
};

virtual IToolBarButton
  &setView        ( View buttonView );

View
  view            ( ) const;

Boolean
  isBitmapVisible ( ) const,
  isTextVisible   ( ) const;

/*------------------------------ Transparency --------------------------------*/
virtual IToolBarButton
  &setTransparentColor   ( const IColor& color = IColor::pink ),
  &resetTransparentColor ( );

virtual IColor
  transparentColor       ( ) const;

virtual Boolean
  hasTransparentColor    ( ) const;

static IColor
  defaultTransparentColor ( );
static void
  setDefaultTransparentColor ( const IColor& aColor = IColor(IColor::pink) );
static void
  clearDefaultTransparentColor ( );
static Boolean
  isDefaultTransparentColorSet ( );

/*-------------------------- Canvas Support ----------------------------------*/
virtual IToolBarButton
  &setLayoutDistorted ( unsigned long layoutAttributeOn,
                        unsigned long layoutAttributeOff );

/*-------------------------- Standard Format ---------------------------------*/
static unsigned long
  standardTextWidth     ( ),
  standardTextLines     ( );

static ISize
  standardBitmapSize    ( );

static void
  setStandardTextWidth  ( unsigned long newWidth = 50 ),
  setStandardTextLines  ( unsigned long newLines = 1 ),
  setStandardBitmapSize ( const ISize&  newSize  = ISize(20,17) );

Boolean
  isStandardFormat      ( ) const;

/*------------------------------- Shredder Support ---------------------------*/
virtual IToolBarButton
 &enableDragDelete  ( Boolean enable = true ),
 &disableDragDelete ( );

Boolean
  allowsDragDelete  ( ) const;

protected:
/*----------------------------- Canvas Layout --------------------------------*/
virtual ISize
  calcMinimumSize ( ) const;

private:
/*--------------------------------- Private ----------------------------------*/
  IToolBarButton            (const IToolBarButton&);
  IToolBarButton& operator= (const IToolBarButton&);
static Style
  fCurrentDefaultStyle;
static IColor
  *fCurrentDefaultTransparent;
static unsigned long
  fgStandardWidth,
  fgStandardLines;
static ISize
  fgStandardSize;
IToolBarButtonData
 *fToolBarButtonData;
};

INESTEDBITFLAGCLASSFUNCS(Style, IToolBarButton);


#pragma pack()

#endif /* _ITBARBUT_ */
