#ifndef _ITBARFRM_
#define _ITBARFRM_
/*******************************************************************************
* FILE NAME: itbarfrm.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IToolBarFrameWindow                                                      *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <iframe.hpp>

class IToolBarFrameData;
class IResourceId;
class IString;

#pragma pack(4)


class IToolBarFrameWindow : public IFrameWindow {
typedef IFrameWindow
  Inherited;

public:
/*------------------------------- Constructors -------------------------------*/
  IToolBarFrameWindow  ( unsigned long windowId,
                         IFrameWindow* owner    );
virtual
  ~IToolBarFrameWindow ( );

/*---------------------------------- Styles ----------------------------------*/
virtual unsigned long
  convertToGUIStyle ( const IBitFlag& style,
                      Boolean         extendedOnly = false ) const;

/*---------------------------- Title Text ------------------------------------*/
virtual IToolBarFrameWindow
  &setTitleText        ( const char* text        ),
  &setTitleText        ( const IResourceId& text );

IString
  titleText            ( ) const;

private:
/*------------------------------ Hidden Members ------------------------------*/
   IToolBarFrameWindow ( const IToolBarFrameWindow& window );
IToolBarFrameWindow
  &operator=           ( const IToolBarFrameWindow& window );

/*--------------------------------- Private ----------------------------------*/
IToolBarFrameData
 *fToolBarFrameData;
}; // IToolBarFrameWindow


#pragma pack()

#endif /* _ITBARFRM_ */
