#ifndef _ITEXTCTL_
  #define _ITEXTCTL_
/*******************************************************************************
* FILE NAME: itextctl.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     ITextControl                                                             *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <icontrol.hpp>

#pragma pack(4)

class IResourceId;
class ISize;
class IString;
class ITextControlData;

class ITextControl : public IControl {
typedef IControl
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
virtual
 ~ITextControl           ( );

/*-------------------------------- Accessors ---------------------------------*/
virtual ITextControl
 &setText                ( const char* text ),
 &setText                ( const IResourceId& text );

virtual IString
  text                   ( ) const;

virtual unsigned long
  textLength             ( ) const;

/*--------------------------- Clipboard Operations ---------------------------*/
static Boolean
  clipboardHasTextFormat ( );

/*----------------------------- Window Painting ------------------------------*/
virtual ISize
  displaySize            ( const char* text = 0 ) const;

/*-------------------------------- Overrides ---------------------------------*/
virtual ITextControl
 &setLayoutDistorted     ( unsigned long layoutAttributeOn,
                           unsigned long layoutAttributeOff );

/*----------------------- Notification Event Descriptions --------------------*/
static INotificationId const
  IC_IMPORTU textId;

protected:
  ITextControl           ( );

private:
/*------------------------------ Hidden Members ------------------------------*/
  ITextControl           ( const ITextControl& textControl );
ITextControl
 &operator=              ( const ITextControl& textControl );

/*--------------------------------- Private ----------------------------------*/
friend class ITextControlNotifyHandler;

Boolean
  fromSetText ( ) const;

ITextControlData
 *fTextControlData;
}; // class ITextControl

#pragma pack()

#endif  // _ITEXTCTL_
