
#ifndef _ITIME_
#define _ITIME_
/*******************************************************************************
* FILE NAME: itime.hpp                                                         *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     ITime                                                                    *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <ibase.hpp>
#include <istring.hpp>

/*  The "struct blocks" must be placed before SOM enablement test  */
#if ( IC_OBSOLETE <= IC_OBSOLETE_2 )
#endif

struct ICnrTime {
  unsigned char hours;
  unsigned char minutes;
  unsigned char seconds;
  unsigned char ucReserved;
};

#pragma pack(4)

class ostream;





class ITime : public IBase {
public:
/*------------------------ Constructors --------------------------------------*/
  ITime       ( );

  ITime       ( long seconds );

  ITime       ( unsigned hours,
                unsigned minutes,
                unsigned seconds = 0 );

  ITime       ( const ITime &aTime );

  ITime       ( const ICnrTime &cnrTime );

/*-------------------------- Current Time ------------------------------------*/
static ITime
  now         ( );

/*-------------------------- Diagnostics -------------------------------------*/
IString
  asString    ( const char *fmt = "%X" ) const;

friend ostream
 &operator << ( ostream     &aStream,
                const ITime &aTime );


/*-------------------------- Time Queries ------------------------------------*/
long
  asSeconds   ( ) const;

ICnrTime
  asICnrTime  ( ) const;

unsigned
  hours       ( ) const,
  minutes     ( ) const,
  seconds     ( ) const;

/*-------------------------- Comparisons -------------------------------------*/
Boolean
  operator == ( const ITime &aTime ) const,
  operator != ( const ITime &aTime ) const,
  operator <  ( const ITime &aTime ) const,
  operator <= ( const ITime &aTime ) const,
  operator >  ( const ITime &aTime ) const,
  operator >= ( const ITime &aTime ) const;

/*------------------------- Manipulations ------------------------------------*/
ITime
  operator +  ( const ITime &aTime ) const,
  operator -  ( const ITime &aTime ) const;

ITime
 &operator += ( const ITime &aTime ),
 &operator -= ( const ITime &aTime );


protected:
/*------------------------- Initialize ---------------------------------------*/
ITime
 &initialize  ( long seconds );

private:
/*------------------------- PRIVATE ------------------------------------------*/
#if ( IC_OBSOLETE <= IC_OBSOLETE_2 )
#endif

long
  ticks;



}; // ITime



#pragma pack()

  #include <itime.inl>

#endif /* _ITIME_ */


