#ifndef _ITIME_INL_
#define _ITIME_INL_ 0
/*******************************************************************************
* FILE NAME: itime.inl                                                         *
*                                                                              *
* DESCRIPTION:                                                                 *
*   This file contains the definition of the inline functions for the          *
*   classes declared in itime.hpp.                                             *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#ifndef _ITIME_
  #undef  _ITIME_INL_
  #define _ITIME_INL_ 1
  #include <itime.hpp>
#endif

extern "C"
  {
  #include <time.h>
  }

#if _ITIME_INL_
  #define inline
#endif

/*------------------------------ Implementation ------------------------------*/
inline ITime& ITime :: initialize ( long seconds )
  {
  const long secondsPerDay = 24*60*60L;
  if ( seconds < 0 )
    this->ticks = secondsPerDay - (-seconds % secondsPerDay);
  else
    this->ticks = seconds % secondsPerDay;
  return *this;
  }
/*------------------------------- Constructors -------------------------------*/
inline ITime :: ITime ( unsigned hours,
                        unsigned minutes,
                        unsigned seconds )
  {
  long secs = hours;
  secs *= 60;
  secs += minutes;
  secs *= 60;
  secs += seconds;
  this->initialize( secs );
  }
inline ITime ITime :: now ( )
  {
  time_t t    = time( 0 );
  tm     time = *localtime( &t );
  return ITime( time.tm_hour, time.tm_min, time.tm_sec );
  }
inline ITime :: ITime ( )
  {
  this->ticks = this->now().ticks;
  }
inline ITime :: ITime ( long seconds )
  {
  this->initialize( seconds );
  }
inline ITime :: ITime ( const ITime &aTime )
  {
  this->ticks = aTime.ticks;
  }
/*-------------------------------- Accessors ---------------------------------*/
inline long ITime :: asSeconds ( ) const
  {
  return this->ticks;
  }
inline unsigned ITime :: hours ( ) const
  {
  // seconds/(seconds/hour) -> hours.
  return ((unsigned)(this->ticks / 3600));
  }
inline unsigned ITime :: minutes ( ) const
  {
  // seconds (past hour)/(seconds/minute) -> minutes.
  return ((unsigned)((this->ticks % 3600 ) / 60));
  }
inline unsigned ITime :: seconds ( ) const
  {
  // seconds (past minute)
  return ((unsigned)(this->ticks % 60));
  }
/*-------------------------------- Comparison --------------------------------*/
inline IBase::Boolean ITime :: operator == ( const ITime &aTime ) const
  {
  return this->ticks == aTime.ticks;
  }
inline IBase::Boolean ITime :: operator != ( const ITime &aTime ) const
  {
  return this->ticks != aTime.ticks;
  }
inline IBase::Boolean ITime :: operator <  ( const ITime &aTime ) const
  {
  return this->ticks <  aTime.ticks;
  }
inline IBase::Boolean ITime :: operator <= ( const ITime &aTime ) const
  {
  return this->ticks <= aTime.ticks;
  }
inline IBase::Boolean ITime :: operator >  ( const ITime &aTime ) const
  {
  return this->ticks >  aTime.ticks;
  }
inline IBase::Boolean ITime :: operator >= ( const ITime &aTime ) const
  {
  return this->ticks >= aTime.ticks;
  }
/*-------------------------- Manipulation Operators --------------------------*/
inline ITime& ITime :: operator += ( const ITime &aTime )
  {
  return this->initialize( this->ticks + aTime.ticks );
  }
inline ITime ITime :: operator + ( const ITime &aTime ) const
  {
  return ITime( this->ticks + aTime.ticks );
  }
inline ITime& ITime :: operator -= ( const ITime &aTime )
  {
  return this->initialize( this->ticks - aTime.ticks );
  }
inline ITime ITime :: operator - ( const ITime &aTime ) const
  {
  return ITime( this->ticks - aTime.ticks );
  }
#endif // _ITIME_INL_
