#ifndef _ITIMER_
#define _ITIMER_

/*******************************************************************************
* FILE NAME: itimer.hpp                                                        *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     ITimer                                                                   *
*     ITimer::Cursor                                                           *
*     ITimerFn                                                                 *
*     ITimerMemberFn                                                           *
*     ITimerMemberFn0                                                          *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <ivbase.hpp>
#include <irefcnt.hpp>

class IString;
class ITimerData;

#pragma pack(4)

class ITimerFn : public IRefCounted {
typedef IRefCounted
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  ITimerFn ( );

virtual
  ~ITimerFn ( );

/*---------------------------- Timer Expiration ------------------------------*/
virtual void
  timerExpired ( unsigned long timerId ) = 0;

private:
/*----------------------------- Hidden Members -------------------------------*/
  ITimerFn      ( const ITimerFn& function );
ITimerFn
  &operator=    ( const ITimerFn& function );

}; // class ITimerFn


template < class T >
class ITimerMemberFn : public ITimerFn {
typedef ITimerFn
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
ITimerMemberFn ( T &object,
                 void ( T::*memberFunction )(unsigned long) )
  : fMemberFunction( memberFunction ), fObject( object )
  {
  }

/*---------------------------- Timer Expiration ------------------------------*/
virtual void
  timerExpired ( unsigned long timerId )
  {
  (fObject.*fMemberFunction)(timerId);
  }

private:
/*----------------------------- Hidden Members -------------------------------*/
  ITimerMemberFn  ( const ITimerMemberFn<T>& timerFunction );
ITimerMemberFn<T>
  &operator=      ( const ITimerMemberFn<T>& timerFunction );

/*--------------------------------- Private ----------------------------------*/
T
  &fObject;
void (T::
  *fMemberFunction)(unsigned long);
}; // ITimerMemberFn


template < class T >
class ITimerMemberFn0 : public ITimerFn {
typedef ITimerFn
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
ITimerMemberFn0 ( T &object,
                  void ( T::*memberFunction )() )
  : fMemberFunction( memberFunction ), fObject( object )
  {
  }

/*---------------------------- Timer Expiration ------------------------------*/
virtual void
  timerExpired ( unsigned long timerId )
  {
  (fObject.*fMemberFunction)();
  }

private:
/*----------------------------- Hidden Members -------------------------------*/
  ITimerMemberFn0 ( const ITimerMemberFn0<T>& timerFunction );
ITimerMemberFn0<T>
 &operator=       ( const ITimerMemberFn0<T>& timerFunction );

/*--------------------------------- Private ----------------------------------*/
T
  &fObject;
void (T::
  *fMemberFunction)();
}; // ITimerMemberFn0


class ITimer : public IVBase {
typedef IVBase
  Inherited;
public:

/*------------------------------- Constructors -------------------------------*/
  ITimer            ( );
  ITimer            ( const IReference<ITimerFn>& timerFunction,
                      unsigned long timerInterval = 1000 );
  ITimer            ( unsigned long timerIdentifier );
  ITimer            ( const ITimer& timer );
  ITimer &operator= ( const ITimer& timer );

virtual
  ~ITimer ( );

/*--------------------------- Starting and Stopping --------------------------*/
virtual ITimer
  &start   ( const IReference<ITimerFn>& timerFunction ),
  &start   ( const IReference<ITimerFn>& timerFunction,
             unsigned long               timerInterval );

virtual ITimer
  &stop    ( );

Boolean
  isStarted ( ) const;

/*-----------------------------Timer Information -----------------------------*/
unsigned long
  id ( ) const;

/*-------------------------------- Diagnostics -------------------------------*/
virtual IString
  asString    ( ) const,
  asDebugInfo ( ) const;

/*--------------------------- Expiration Interval ----------------------------*/
unsigned long
  interval ( ) const;

virtual ITimer
 &setInterval ( unsigned long aInterval = 1000 );


class Cursor : public IVBase {
typedef IVBase
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  Cursor ( );
virtual
 ~Cursor ( );

/*------------------------------ Timer Iteration -----------------------------*/
virtual Boolean
  setToFirst ( ),
  setToNext  ( ),
  isValid    ( ) const;

virtual void
  invalidate ( );

private:
/*--------------------------------- Private ----------------------------------*/
friend ITimer;
unsigned long
  fIndex;
}; // class ITimer::Cursor

/*-------------------------- Retrieving Objects ------------------------------*/
static ITimer
  timerAt ( const Cursor& cursor );

/*------------------------------- Comparison ---------------------------------*/
Boolean
  operator == ( const ITimer timer );

private:
/*--------------------------------- Private ----------------------------------*/
unsigned long
  fIndex;

ITimerData
 *fTimerData;
}; // ITimer

#pragma pack()

#endif /* _ITIMER_ */
