/*******************************************************************************
* FILE NAME: iview.hpp                                                         *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IView                                                                    *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*   Portions or this component are based on work originating from Taligent.    *
*   (C) Copyright Taligent, Inc. 1996 - All rights reserved.                   *
*                                                                              *
*******************************************************************************/
#ifndef _IVIEW_
#define _IVIEW_

#include <icanvas.hpp>

// Forward References
class IGUIBundle;
class IComponent;
class IModel;
class IPresSpaceHandle;
class IViewImplementation;

// Classes defined in this module
class IView;

#pragma pack(4)


/*******************************************************************************
*                                                                              *
*   The IView class is a simple content view for use with document             *
*   components.   It serves a the base class for document views.               *
*                                                                              *
*******************************************************************************/

class IView : public ICanvas {
public:

/*---------------------- Initialization and Finalization ---------------------*/

    virtual void            initialize ();
    virtual void            finalize ();
    virtual                 ~IView();


/*------------------- Notification and Painting Event Handlers ---------------*/

    virtual void            handleNotification( const INotificationEvent& );
    virtual void            draw( IPresSpaceHandle&,
                                  const IRectangle&,
                                  Boolean metaFile = false );
    virtual void            drawContents( IPresSpaceHandle&,
                                          const IRectangle&,
                                          Boolean );


/*------------------------------ Informational -------------------------------*/

    virtual Boolean         isDropTarget() const;
    virtual Boolean         isDragSource() const;
    IGUIBundle&             bundle() const;
    IComponent&             component() const;
    IModel*                 model() const;


/*---------------------------- Moving & Sizing -------------------------------*/

    IView&                  setViewClient( IControl* clientControl );
    IControl*               viewClient();
    virtual IView&          sizeTo(const ISize& newSize);
    virtual IView&          moveSizeTo( const IRectangle& newRect );

protected:
                            IView( IGUIBundle& );
                            IView( const IView& );

private:
    IView&                  operator=( const IView& );

    IComponent*             fpComponent;
    IGUIBundle*             fpBundle;
    IViewImplementation*    fpImplementation;

    IControl*               fpViewClient;

};

  #include <iview.inl>


#pragma pack()


#endif // _IVIEW_
