#ifndef _IVPORT_
  #define _IVPORT_
/*******************************************************************************
* FILE NAME: ivport.hpp                                                        *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IViewPort                                                                *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <icanvas.hpp>
#include <inotify.hpp>
#include <ipoint.hpp>
#include <irect.hpp>

class IColor;
class IScrollBar;
class IViewPortData;
class IViewRectangle;
class IWindowHandle;

#pragma pack(4)

class IViewPort : public ICanvas {
typedef ICanvas
  Inherited;
public:
class Style;

/*------------------------------- Constructors -------------------------------*/
  IViewPort ( unsigned long     windowIdentifier,
              IWindow*          parent,
              IWindow*          owner,
              const IRectangle& initialSize = IRectangle(),
              const Style&      style = defaultStyle() );

virtual
 ~IViewPort ( );

/*---------------------------------- Styles ----------------------------------*/
INESTEDBITFLAGCLASSDEF2(Style, IViewPort, IWindow, ICanvas);
static const Style
  IC_IMPORTU alwaysHorizontalScrollBar,
  IC_IMPORTU asNeededHorizontalScrollBar,
  IC_IMPORTU noHorizontalScrollBar,
  IC_IMPORTU alwaysVerticalScrollBar,
  IC_IMPORTU asNeededVerticalScrollBar,
  IC_IMPORTU noVerticalScrollBar,
  IC_IMPORTU noViewWindowFill,
  IC_IMPORTU classDefaultStyle;
static const Style
  IC_IMPORTU expandableViewWindow;
static Style
  defaultStyle      ( );
static void
  setDefaultStyle   ( const Style&    style );

virtual unsigned long
  convertToGUIStyle ( const IBitFlag& style,
                      Boolean         extendedOnly = false ) const;

/*----------------------------- Child Scroll Bars ----------------------------*/
IScrollBar
 *horizontalScrollBar ( ) const,
 *verticalScrollBar   ( ) const;

/*----------------------------- View Window ----------------------------------*/
virtual IWindowHandle
  viewWindow               ( );
virtual IRectangle
  viewWindowDrawRectangle  ( ) const;
virtual IViewPort
 &scrollViewVerticallyTo   ( unsigned long topOffset ),
 &scrollViewHorizontallyTo ( unsigned long leftOffset );
virtual IViewPort
 &setViewWindowSize        ( const ISize& size );
virtual ISize
  viewWindowSize           ( ) const;

/*----------------------------- Layout Support -------------------------------*/
virtual IViewPort
 &setLayoutDistorted ( unsigned long layoutAttributeOn,
                       unsigned long layoutAttributeOff );

/*---------------------------- Notification Members --------------------------*/
static INotificationId const
  IC_IMPORTU viewWindowSizeId;

protected:
/*----------------------------- Layout Support -------------------------------*/
virtual ISize
  calcMinimumSize ( ) const;
virtual IViewPort
 &layout          ( );

/*------------------------------ View Window ---------------------------------*/
virtual IViewPort
 &setupScrollBars     ( ),
 &positionViewWindow  ( const IWindowHandle& viewWindow,
                        const IRectangle& viewRectangle ),
 &setTopLeftViewPoint ( const IPoint& topLeft );

IPoint
  topLeftViewPoint    ( ) const;

private:
/*----------------------------- Hidden Members -------------------------------*/
  IViewPort ( const IViewPort& viewPort );
IViewPort
 &operator= ( const IViewPort& viewPort );

/*--------------------------------- Private ----------------------------------*/
static Style
  currentDefaultStyle;
IPoint
  ptClTopLeftView;
IScrollBar
 *psbClVert,
 *psbClHorz;
IViewRectangle
 *pcvClViewRect;
ISize
  sizClViewWindow;

enum Flag { initialized=1, resizeHandlerAdded=2, scrollHandlerAdded=4,
            keyboardHandlerAdded=8, paintHandlerAdded=16,
            rectanglePaintHandlerAdded=32, useMinimumSizeView=64 };
unsigned long
  ulClFlag;

IViewPortData
 *fViewPortData;

}; // IViewPort

INESTEDBITFLAGCLASSFUNCS(Style, IViewPort);

#pragma pack()

  #include <ivport.inl>

#endif /* _IVPORT_ */
