#ifndef _IDACONN_
#define _IDACONN_

/*******************************************************************************
* FILE NAME: IDACONN.hpp                                                       *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the class:                                                  *
*     IVBDatastore - IDatastore actions on a background thread.                *
*     IVBDatastoreDB2 - IDatastoreDB2 actions on a background thread.          *
*     IVBDatastoreODBC - IDatastoreODBC actions on a background thread.        *
*******************************************************************************/

/***********************************************

    Licensed Materials - Property of IBM

    5622-880   5801-AAR

    (c) Copyright IBM Corp 1991, 1996.

************************************************/

#ifndef _IDATHRD_
#include "IDAThrd.hpp"
#endif

#ifndef _IDSMCON_HPP_
#include <idsmcon.hpp>
#endif
#ifndef _IDSMCDB_HPP_
#include <idsmcdb.hpp>
#endif
#ifndef _IDSMCOD_HPP_
#include <idsmcod.hpp>
#endif

#pragma pack(4)

class DAX_IMPORTEXPORT IVBDatastore : public IDatastore
{
  public:

    IVBDatastore();
    IVBDatastore ( const char* datastoreName,
                   const char* userName = "",
                   const char* authentication = "");
    virtual ~IVBDatastore();

    Boolean isBusy() const;

    virtual IVBDatastore&
       connect ();
    virtual IVBDatastore&
       connect ( const char* datastoreName);
    virtual IVBDatastore&
       connect ( const char* userName,
                 const char* authentication);
    virtual IVBDatastore&
       connect ( const char* datastoreName,
                 const char* userName,
                 const char* authentication );

    virtual IVBDatastore&
       disconnect ();

    virtual IVBDatastore&
       commit ();

    virtual IVBDatastore&
       rollback ();

    virtual IVBDatastore&
       executeSQL(const char* aCmd);

    IVBDatastore& notifyObservers( const INotificationEvent& event );

  protected:
    IVBDatastore& notifyObservers( const INotificationId& id );

  private:
    class IDAOnThread* iOnThread;

};

class DAX_IMPORTEXPORT IVBDatastoreDB2 : public IDatastoreDB2
{
  public:

    IVBDatastoreDB2();
    IVBDatastoreDB2 ( const char* datastoreName,
                      const char* connectString = "" );
    virtual ~IVBDatastoreDB2();

    Boolean isBusy() const;

    virtual IVBDatastoreDB2&
       connect ();
    virtual IVBDatastoreDB2&
       connect ( const char* datastoreName);
    virtual IVBDatastoreDB2&
       connect ( const char* userName,
                 const char* authentication);
    virtual IVBDatastoreDB2&
       connect ( const char* datastoreName,
                 const char* userName,
                 const char* authentication );
    virtual IVBDatastoreDB2&
       connect ( const char* datastoreName,
                 const char* connectString,
                 const char* userName,
                 const char* authentication );

    virtual IVBDatastoreDB2&
       disconnect ();

    virtual IVBDatastoreDB2&
       commit ();

    virtual IVBDatastoreDB2&
       rollback ();

    virtual IVBDatastoreDB2&
       executeSQL(const char* aCmd);

    IVBDatastoreDB2& notifyObservers( const INotificationEvent& event );

  protected:
    IVBDatastoreDB2& notifyObservers( const INotificationId& id );

  private:
    class IDAOnThread* iOnThread;

};

class DAX_IMPORTEXPORT IVBDatastoreODBC : public IDatastoreODBC
{
  public:

    IVBDatastoreODBC();
    IVBDatastoreODBC( const char* datastoreName,
                      const char* connectString = "" );
    virtual ~IVBDatastoreODBC();

    Boolean isBusy() const;

    virtual IVBDatastoreODBC&
       connect ();
    virtual IVBDatastoreODBC&
       connect ( const char* datastoreName);
    virtual IVBDatastoreODBC&
       connect ( const char* userName,
                 const char* authentication);
    virtual IVBDatastoreODBC&
       connect ( const char* datastoreName,
                 const char* userName,
                 const char* authentication );
    virtual IVBDatastoreODBC&
       connect ( const char* datastoreName,
                 const char* connectString,
                 const char* userName,
                 const char* authentication );

    virtual IVBDatastoreODBC&
       disconnect ();

    virtual IVBDatastoreODBC&
       commit ();

    virtual IVBDatastoreODBC&
       rollback ();

    virtual IVBDatastoreODBC&
       executeSQL(const char* aCmd);

    IVBDatastoreODBC& notifyObservers( const INotificationEvent& event );

  protected:
    IVBDatastoreODBC& notifyObservers( const INotificationId& id );

  private:
    class IDAOnThread* iOnThread;

};

#pragma pack()

#endif
