#ifndef __new_h
   #define __new_h

   /********************************************************************/
   /*  <new.h> header file                                             */
   /*                                                                  */
   /*  VisualAge for C++ for Windows, Version 3.5                      */
   /*    Licensed Material - Property of IBM                           */
   /*                                                                  */
   /*  5801-ARR and Other Materials                                    */
   /*                                                                  */
   /*  (c) Copyright IBM Corp 1991, 1996. All rights reserved.         */
   /*                                                                  */
   /********************************************************************/
   #include <stddef.h>

   // Definition of C++ storage management -- new & delete

   void (*set_new_handler (void(*)()))();
   #ifdef __MULTI__
      void (*_set_mt_new_handler (void(*)()))();
   #endif

   // The standard favourites

   #ifndef __DEBUG_ALLOC__
      void *operator new(size_t size);
      void *operator new(size_t size, void *location);

      void *operator new[](size_t size);
      void *operator new[](size_t size, void *location);

      void operator delete(void *location);

      void operator delete[](void *location);
   #else
      #include <stdlib.h>

      void *operator new(size_t size, const char *filename, size_t lineno);
      void *operator new(size_t size, const char *filename, size_t lineno, void *location);

      void *operator new[](size_t size, const char *filename, size_t lineno);
      void *operator new[](size_t size, const char *filename, size_t lineno, void *location);

      void operator delete(void *location, const char *filename, size_t lineno);

      void operator delete[](void *location, const char *filename, size_t lineno);
   #endif
#endif
