#if (defined(__IBMC__) || defined(__IBMCPP__))
#pragma info( none )
#ifndef __CHKHDR__
   #pragma info( none )
#endif
#pragma info( restore )
#endif

#ifndef __regex_h
   #define __regex_h

   #ifdef __cplusplus
      extern "C" {
   #endif

   #ifndef  _LNK_CONV
     #ifdef _M_I386
         #define  _LNK_CONV   _Optlink
     #else
         #define  _LNK_CONV
     #endif
   #endif

   #ifndef _IMPORT
      #ifdef __IMPORTLIB__
         #define _IMPORT _Import
      #else
         #define _IMPORT
      #endif
   #endif

   /********************************************************************/
   /*  <regex.h> header file                                           */
   /*                                                                  */
   /*  VisualAge for C++ for Windows, Version 3.5                      */
   /*    Licensed Material - Property of IBM                           */
   /*                                                                  */
   /*  5801-ARR and Other Materials                                    */
   /*                                                                  */
   /*  (c) Copyright IBM Corp 1991, 1996. All rights reserved.         */
   /*                                                                  */
   /********************************************************************/

   #include <stddef.h>           /* size_t, wchar_t definition required */

   #define __REG_SUBEXP_MAX        9        /* Maximum # of subexpressions                */

   /* regcomp() cflags */

   #define REG_EXTENDED        0x001        /* Use Extended RE syntax rules               */
   #define REG_ICASE           0x002        /* Ignore case in match                       */
   #define REG_NEWLINE         0x004        /* Convert <backslash><n> to <newline>        */
   #define REG_NOSUB           0x008        /* regexec() not report subexpressions        */


   /* regexec() eflags */

   #define REG_NOTBOL          0x100        /* First character not start of line          */
   #define REG_NOTEOL          0x200        /* Last character not end of line             */


   /* Regular Expression error codes */

   #define REG_NOMATCH             1        /* RE pattern not found                       */
   #define REG_BADPAT              2        /* Invalid Regular Expression                 */
   #define REG_ECOLLATE            3        /* Invalid collating element                  */
   #define REG_ECTYPE              4        /* Invalid character class                    */
   #define REG_EESCAPE             5        /* Last character is \                        */
   #define REG_ESUBREG             6        /* Invalid number in \digit                   */
   #define REG_EBRACK              7        /* [] imbalance                               */
   #define REG_EPAREN              8        /* \( \) or () imbalance                      */
   #define REG_EBRACE              9        /* \{ \} or { } imbalance                     */
   #define REG_BADBR              10        /* Invalid \{ \} range exp                    */
   #define REG_ERANGE             11        /* Invalid range exp endpoint                 */
   #define REG_ESPACE             12        /* Out of memory                              */
   #define REG_BADRPT             13        /* ?*+ not preceded by valid RE               */
   #define REG_ECHAR              14        /* invalid multibyte character                */
   #define REG_EBOL               15        /*  anchor and not BOL                       */
   #define REG_EEOL               16        /* $ anchor and not EOL                       */

   #ifndef __mbstate_t
      #define __mbstate_t
      typedef short      mbstate_t;
   #endif

   typedef struct {                         /* regcomp() data saved for regexec()         */
           size_t  re_nsub;                 /* # of subexpressions in RE pattern          */
           void    *re_comp;                /* compiled RE; freed by regfree()            */
           int     re_cflags;               /* saved cflags for regexec()                 */
           size_t  re_erroff;               /* RE pattern error offset                    */
           size_t  re_len;                  /* # wchar_t chars in compiled pattern        */
           wchar_t re_ucoll[2];             /* min/max unique collating values            */
           void    *re_lsub[__REG_SUBEXP_MAX+1]; /* start subexp                          */
           void    *re_esub[__REG_SUBEXP_MAX+1]; /* end subexp                            */
           unsigned char re_map[256];       /* map of valid pattern characters            */
           mbstate_t     re_shift;          /* Saved shift state                          */
           short         re_dbcs;           /* May start with DBCS character              */
   } regex_t;

   #ifndef __off_t
     typedef long  off_t;                /* file offset */
     #define __off_t
   #endif

   typedef struct {                      /* substring locations - from regexec()          */
           off_t   rm_so;                /* offset of substring                           */
           off_t   rm_eo;                /* offset of first char after substring          */
           mbstate_t rm_ss;              /* Shift state at start of substring             */
           mbstate_t rm_es;              /* Shift state at end of substring               */
   } regmatch_t;


   /* Regular Expression function prototypes */

   extern int      _LNK_CONV regcomp(regex_t *, const char *, int);
   extern int      _LNK_CONV regexec(const regex_t *, const char *, size_t, regmatch_t *, int);
   extern size_t   _LNK_CONV regerror(int, const regex_t *, char *, size_t);
   extern void     _LNK_CONV regfree(regex_t *);

   #ifdef __cplusplus
      }
   #endif

#endif

#if (defined(__IBMC__) || defined(__IBMCPP__))
#pragma info( none )
#ifndef __CHKHDR__
   #pragma info( restore )
#endif
#pragma info( restore )
#endif

