/********************************************************************/
/*  <stdexcpt.h> header file                                        */
/*                                                                  */
/*  VisualAge for C++ for Windows, Version 3.5                      */
/*    Licensed Material - Property of IBM                           */
/*                                                                  */
/*  5801-ARR and Other Materials                                    */
/*                                                                  */
/*  (c) Copyright IBM Corp 1991, 1996. All rights reserved.         */
/*                                                                  */
/********************************************************************/

#ifndef __STDEXCEPT_H
#define __STDEXCEPT_H

class exception {
public:
  exception(const char* exceptionName) : desc(exceptionName), alloced(0) { }
  virtual ~exception();
  virtual const char* what() const { return desc; }
protected:
  exception() : desc(0), alloced(0) { }
private:
  const char* desc;
  unsigned int alloced;
};

class logic_error : public exception {
public:
  logic_error(const char* exceptionName) : exception(exceptionName) { }
  virtual ~logic_error();
};

class bad_cast : public logic_error {
public:
  bad_cast(const char* = 0) : logic_error ("bad_cast") { }
  virtual ~bad_cast();
};

class bad_typeid: public logic_error {
public:
  bad_typeid(const char* = 0) : logic_error ("bad_typeid") { }
  virtual ~bad_typeid();
};

#endif /* __STDEXCEPT_H */
