#pragma info( none )
#ifndef __CHKHDR__
   #pragma info( none )
#endif
#pragma info( restore )

#ifndef __stream_h
   #define __stream_h

   /********************************************************************/
   /*  <stream.h> header file                                          */
   /*                                                                  */
   /*  VisualAge for C++ for Windows, Version 3.5                      */
   /*    Licensed Material - Property of IBM                           */
   /*                                                                  */
   /*  5801-ARR and Other Materials                                    */
   /*                                                                  */
   /*  (c) Copyright IBM Corp 1991, 1996. All rights reserved.         */
   /*                                                                  */
   /*                                                                  */
   /*                                                                  */
   /*  Licensed Materials - Property of USL                            */
   /*                                                                  */
   /*  Standard Class Library Version 3.0                              */
   /*  Copyright (C) Unix System Laboratories Inc. 1991.               */
   /*  All rights reserved                                             */
   /*                                                                  */
   /********************************************************************/

   /**************************************************************************/
   /*  C++ source for the C++ Language System, Release 3.0.  This product    */
   /*  is a new release of the original cfront developed in the computer     */
   /*  science research center of AT&T Bell Laboratories.                    */
   /*                                                                        */
   /*  Copyright (c) 1991 AT&T and UNIX System Laboratories, Inc.            */
   /*  Copyright (c) 1984, 1989, 1990 AT&T.  All Rights Reserved.            */
   /*                                                                        */
   /*  THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE of AT&T and UNIX System   */
   /*  Laboratories, Inc.  The copyright notice above does not evidence      */
   /*  any actual or intended publication of such source code.               */
   /*                                                                        */
   /*  UNIX is a registered trademark of UNIX System Laboratories, Inc.      */
   /*                                                                        */
   /*  ident "@(#)ctrans:incl-master/const-headers/stream.h  1.4"            */
   /**************************************************************************/

   #ifndef _IMPORT
      #ifdef __IMPORTLIB__
         #define _IMPORT _Import
      #else
         #define _IMPORT
      #endif
   #endif

   #include <iostream.h>
   #include <iomanip.h>
   #include <stdiostr.h>
   #include <fstream.h>
           /* for filebuf */

   #ifndef NULL
   #define NULL    0
   #endif

   extern char* _IMPORT oct(long, int =0);
   extern char* _IMPORT dec(long, int =0);
   extern char* _IMPORT hex(long, int =0);

   extern char* _IMPORT chr(int, int =0); /* chr(0) is the empty string "" */
   extern char* _IMPORT str(const char*, int =0);
   extern char* _IMPORT form(const char* ...);
                           /* printf format
                            * Things may go terribly wrong (maybe even core
                            * dumps, if form tries to create a string with
                            * more than "max_field_width" characters. */

   /* WS used to be a special in streams. The WS manipulator
    * is implemented differently but may be extracted from an istream
    * with the same effect as the old form.
    */

   extern istream& _IMPORT WS(istream&) ;
   extern void _IMPORT eatwhite(istream&) ;

   static const int input = (ios::in) ;
   static const int output = (ios::out) ;
   static const int append = (ios::app) ;
   static const int atend = (ios::ate) ;
   static const int _good = (ios::goodbit) ;
   static const int _bad = (ios::badbit) ;
   static const int _fail = (ios::failbit) ;
   static const int _eof = (ios::eofbit) ;

   typedef ios::io_state state_value ;

#endif

#pragma info( none )
#ifndef __CHKHDR__
   #pragma info( restore )
#endif
#pragma info( restore )


