#pragma info( none )
#ifndef __CHKHDR__
   #pragma info( none )
#endif
#pragma info( restore )

#ifndef __strstream_h
   #define __strstream_h

   /********************************************************************/
   /*  <strstrea.h> header file                                        */
   /*                                                                  */
   /*  VisualAge for C++ for Windows, Version 3.5                      */
   /*    Licensed Material - Property of IBM                           */
   /*                                                                  */
   /*  5801-ARR and Other Materials                                    */
   /*                                                                  */
   /*  (c) Copyright IBM Corp 1991, 1996. All rights reserved.         */
   /*                                                                  */
   /*                                                                  */
   /*                                                                  */
   /*  Licensed Materials - Property of USL                            */
   /*                                                                  */
   /*  Standard Class Library Version 3.0                              */
   /*  Copyright (C) Unix System Laboratories Inc. 1991.               */
   /*  All rights reserved                                             */
   /*                                                                  */
   /********************************************************************/

   /**************************************************************************/
   /*  C++ source for the C++ Language System, Release 3.0.  This product    */
   /*  is a new release of the original cfront developed in the computer     */
   /*  science research center of AT&T Bell Laboratories.                    */
   /*                                                                        */
   /*  Copyright (c) 1991 AT&T and UNIX System Laboratories, Inc.            */
   /*  Copyright (c) 1984, 1989, 1990 AT&T.  All Rights Reserved.            */
   /*                                                                        */
   /*  THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE of AT&T and UNIX System   */
   /*  Laboratories, Inc.  The copyright notice above does not evidence      */
   /*  any actual or intended publication of such source code.               */
   /*                                                                        */
   /*  UNIX is a registered trademark of UNIX System Laboratories, Inc.      */
   /*                                                                        */
   /*  ident "@(#)ctrans:incl-master/const-headers/strstream.h       1.7"    */
   /**************************************************************************/

   #ifndef _IMPORT
      #ifdef __IMPORTLIB__
         #define _IMPORT _Import
      #else
         #define _IMPORT
      #endif
   #endif

   #include <iostream.h>

   #pragma pack(4)

   class _IMPORT strstreambuf : public streambuf
   {
   public:
                           strstreambuf() ;
                           strstreambuf(int) ;
                           strstreambuf(void* (*a)(long), void (*f)(void*)) ;
                           strstreambuf(char* b, int size, char* pstart = 0 ) ;
                           strstreambuf(signed char* b, int size, signed char* pstart = 0 ) ;
                           strstreambuf(unsigned char* b, int size, unsigned char* pstart = 0 ) ;

           /*
            FUNCTION  int streambuf::pcount() IS INTERNAL AND SHOULD
            NOT BE USED.
           */
           int             pcount();

           void            freeze(int n=1) ;
           char*           str() ;
                           ~strstreambuf() ;

   public: /* virtuals  */
           virtual int     doallocate() ;
           virtual int     overflow(int) ;
           virtual int     underflow() ;
           virtual streambuf*
                           setbuf(char*  p, int l) ;
           virtual streampos
                           seekoff(streamoff,ios::seek_dir,int) ;

   private:
           void            init(char*,int,char*) ;

           void*           (*afct)(long) ;
           void            (*ffct)(void*) ;
           int             ignore_oflow ;
           int             froozen ;
           int             auto_extend ;

   public:
           int             isfrozen() { return froozen; }
           } ;

   class _IMPORT strstreambase : public virtual ios {
   public:
           strstreambuf*   rdbuf() ;
   protected:
                           strstreambase(char*, int, char*) ;
                           strstreambase() ;
                           ~strstreambase() ;
   private:
           strstreambuf    buf ;
           } ;

   class _IMPORT istrstream : public strstreambase, public istream {
   public:
                           istrstream(char* str);
                           istrstream(signed char* str);
                           istrstream(unsigned char* str);
                           istrstream(char* str, int size ) ;
                           istrstream(signed char* str, int size);
                           istrstream(unsigned char* str, int size);
                           istrstream(const char* str);
                           istrstream(const signed char* str);
                           istrstream(const unsigned char* str);
                           istrstream(const char* str, int size ) ;
                           istrstream(const signed char* str, int size);
                           istrstream(const unsigned char* str, int size);
                           ~istrstream() ;
           } ;

   class _IMPORT ostrstream : public strstreambase, public ostream {
   public:
                           ostrstream(char* str, int size, int=ios::out) ;
                           ostrstream(signed char* str, int size, int=ios::out) ;
                           ostrstream(unsigned char* str, int size, int=ios::out) ;
                           ostrstream() ;
                           ~ostrstream() ;
           char*           str() ;
           int             pcount() ;
           } ;


   class _IMPORT strstream : public strstreambase, public iostream {
   public:
                           strstream() ;
                           strstream(char* str, int size, int mode) ;
                           strstream(signed char* str, int size, int mode) ;
                           strstream(unsigned char* str, int size, int mode) ;
                           ~strstream() ;
           char*           str() ;
           } ;

   #pragma pack()

#endif

#pragma info( none )
#ifndef __CHKHDR__
   #pragma info( restore )
#endif
#pragma info( restore )


