#ifndef __wctype_h
   #define __wctype_h

   #ifdef __cplusplus
      extern "C" {
   #endif

   #ifndef  _LNK_CONV
     #ifdef _M_I386
       #define  _LNK_CONV   _Optlink
     #else
       #define _LNK_CONV
     #endif
   #endif

   #ifndef _IMPORT
      #ifdef __IMPORTLIB__
         #define _IMPORT _Import
      #else
         #define _IMPORT
      #endif
   #endif

   /********************************************************************/
   /*  <wctype.h> header file                                          */
   /*                                                                  */
   /*  VisualAge for C++ for Windows, Version 3.5                      */
   /*    Licensed Material - Property of IBM                           */
   /*                                                                  */
   /*  5801-ARR and Other Materials                                    */
   /*                                                                  */
   /*  (c) Copyright IBM Corp 1991, 1996. All rights reserved.         */
   /*                                                                  */
   /********************************************************************/

   #include <stdio.h>
   #include <stdarg.h>

  #ifndef __wchar_t
     #define __wchar_t
     typedef unsigned short wchar_t;
  #endif

  #ifndef __wctype_t
     #define __wctype_t
     typedef unsigned int        wctype_t;
  #endif

  #ifndef __wint_t
     #define __wint_t
     typedef int        wint_t;
  #endif

  #ifndef WEOF
     #define WEOF -1
  #endif

  #ifndef __ISXDIGIT
     #define __ISXDIGIT       0x0001U
  #endif
  #ifndef __ISDIGIT
     #define __ISDIGIT        0x0002U
  #endif
  #ifndef __ISSPACE
     #define __ISSPACE        0x0008U
  #endif
  #ifndef __ISPUNCT
     #define __ISPUNCT        0x0010U
  #endif
  #ifndef __ISCNTRL
     #define __ISCNTRL        0x0020U
  #endif
  #ifndef __ISLOWER
     #define __ISLOWER        0x0040U
  #endif
  #ifndef __ISUPPER
     #define __ISUPPER        0x0080U
  #endif
  #ifndef __ISALPHA
     #define __ISALPHA        0x0100U
  #endif
  #ifndef __ISGRAPH
     #define __ISGRAPH        0x0200U
  #endif
  #ifndef __ISPRINT
     #define __ISPRINT        0x0400U
  #endif
  #ifndef __ISALNUM
     #define __ISALNUM        0x0800U
  #endif
  #ifndef __ISBLANK
     #define __ISBLANK        0x1000U
  #endif

  /* indexes of toupper/tolower tables in _ctype table */
  #ifndef _TOUPPER_INDEX
     #define _TOUPPER_INDEX   257
  #endif
  #ifndef _TOLOWER_INDEX
     #define _TOLOWER_INDEX   514
  #endif

  #if defined _WIN32S
     extern const unsigned short** _IMPORT _LNK_CONV __ctype( void );
     extern const unsigned char ** _IMPORT _LNK_CONV __ctype_upperidx( void );
     extern const unsigned char ** _IMPORT _LNK_CONV __ctype_loweridx( void );
     extern const wchar_t       ** _IMPORT _LNK_CONV __ctype_upper( void );
     extern const wchar_t       ** _IMPORT _LNK_CONV __ctype_lower( void );
     extern const unsigned char ** _IMPORT _LNK_CONV __ctype_ctypeidx( void );
     extern const unsigned short** _IMPORT _LNK_CONV __ctype_cmask( void );
     extern const unsigned int  ** _IMPORT _LNK_CONV __ctype_mask( void );
     #define _ctype           (*__ctype())
     #define _ctype_upperidx  (*__ctype_upperidx())
     #define _ctype_loweridx  (*__ctype_loweridx())
     #define _ctype_upper     (*__ctype_upper())
     #define _ctype_lower     (*__ctype_lower())
     #define _ctype_ctypeidx  (*__ctype_ctypeidx())
     #define _ctype_cmask     (*__ctype_cmask())
     #define _ctype_mask      (*__ctype_mask())
  #else
     extern const unsigned short* _IMPORT _ctype;
     extern const unsigned char * _IMPORT _ctype_upperidx;
     extern const unsigned char * _IMPORT _ctype_loweridx;
     extern const wchar_t       * _IMPORT _ctype_upper;
     extern const wchar_t       * _IMPORT _ctype_lower;
     extern const unsigned char * _IMPORT _ctype_ctypeidx;
     extern const unsigned short* _IMPORT _ctype_cmask;
     extern const unsigned int  * _IMPORT _ctype_mask;
  #endif

  static int  __temp;
  static int  __temp2;

  extern int      _IMPORT (_LNK_CONV iswalnum) (wint_t);
  extern int      _IMPORT (_LNK_CONV iswalpha) (wint_t);
  #ifdef __EXTENDED__
     extern int   _IMPORT (_LNK_CONV iswblank) (wint_t);
  #endif
  extern int      _IMPORT (_LNK_CONV iswcntrl) (wint_t);
  extern int      _IMPORT (_LNK_CONV iswdigit) (wint_t);
  extern int      _IMPORT (_LNK_CONV iswgraph) (wint_t);
  extern int      _IMPORT (_LNK_CONV iswlower) (wint_t);
  extern int      _IMPORT (_LNK_CONV iswprint) (wint_t);
  extern int      _IMPORT (_LNK_CONV iswpunct) (wint_t);
  extern int      _IMPORT (_LNK_CONV iswspace) (wint_t);
  extern int      _IMPORT (_LNK_CONV iswupper) (wint_t);
  extern int      _IMPORT (_LNK_CONV iswxdigit)(wint_t);
  extern wint_t   _IMPORT (_LNK_CONV towlower) (wint_t);
  extern wint_t   _IMPORT (_LNK_CONV towupper) (wint_t);
  extern wctype_t _IMPORT (_LNK_CONV wctype)   (const char *);
  extern int      _IMPORT (_LNK_CONV iswctype) (wint_t, wctype_t);

  #define iswalnum(c)  __iswalnum(c)
  #define iswalpha(c)  __iswalpha(c)
  #ifdef __EXTENDED__
     #define iswblank(c)  __iswblank(c)
  #endif
  #define iswcntrl(c)  __iswcntrl(c)
  #define iswdigit(c)  __iswdigit(c)
  #define iswgraph(c)  __iswgraph(c)
  #define iswlower(c)  __iswlower(c)
  #define iswprint(c)  __iswprint(c)
  #define iswpunct(c)  __iswpunct(c)
  #define iswspace(c)  __iswspace(c)
  #define iswupper(c)  __iswupper(c)
  #define iswxdigit(c) __iswxdigit(c)
  #define towlower(c)  __towlower(c)
  #define towupper(c)  __towupper(c)
  #define iswctype(c, d) __iswctype(c, d)

  #define __SBCK(a,m)   (_ctype[a] & m)
  #define __SBCK2(a,m)  (_ctype_cmask == 0 ? 0                         \
                        :_ctype_cmask[a] & (m >> 16))
  #define __MBCK(a,m)   (((_ctype_ctypeidx == 0) ||                    \
                         (_ctype_ctypeidx[__temp>>8] == 0)) ? 0        \
                        : _ctype_mask[(_ctype_ctypeidx                 \
                        [__temp>>8]*256)+(__temp&0x00ff)] & m)
  #define __VALCK(a,m)  ((a)<256?__SBCK(a,m):__MBCK(a,m))
  #define __iswalpha(a)  (__temp=(a),__VALCK(__temp,__ISALPHA))
  #define __iswalnum(a)  (__temp=(a),__VALCK(__temp,__ISALNUM))
  #ifdef __EXTENDED__
    #define __iswblank(a)  (__temp=(a),__VALCK(__temp,__ISBLANK))
  #endif
  #define __iswcntrl(a)  (__temp=(a),__VALCK(__temp,__ISCNTRL))
  #define __iswdigit(a)  (__temp=(a),__VALCK(__temp,__ISDIGIT))
  #define __iswgraph(a)  (__temp=(a),__VALCK(__temp,__ISGRAPH))
  #define __iswlower(a)  (__temp=(a),__VALCK(__temp,__ISLOWER))
  #define __iswprint(a)  (__temp=(a),__VALCK(__temp,__ISPRINT))
  #define __iswpunct(a)  (__temp=(a),__VALCK(__temp,__ISPUNCT))
  #define __iswspace(a)  (__temp=(a),__VALCK(__temp,__ISSPACE))
  #define __iswupper(a)  (__temp=(a),__VALCK(__temp,__ISUPPER))
  #define __iswxdigit(a) (__temp=(a),__VALCK(__temp,__ISXDIGIT))
  #define __iswctype(a,m) (__temp=(a), __temp2=(m),                    \
                          (__temp < 256                                \
                           ? (__temp2 > 0x8000                         \
                              ? __SBCK2(__temp,__temp2)                \
                              : __SBCK(__temp,__temp2))                \
                           : __MBCK(__temp,__temp2)))
  #define __SBUPPER(a)       (_ctype[a+_TOUPPER_INDEX])
  #define __MBUPPER(a)       (((_ctype_upperidx == 0) ||               \
                              (_ctype_upperidx[__temp>>8] == 0)) ? (a) \
                             : _ctype_upper                            \
                         [_ctype_upperidx[__temp>>8]*256+(__temp&0x00ff)])

  #define __SBLOWER(a)       (_ctype[a+_TOLOWER_INDEX])
  #define __MBLOWER(a)       (((_ctype_loweridx == 0) ||               \
                              (_ctype_loweridx[__temp>>8] == 0)) ? (a) \
                             : _ctype_lower                            \
             [_ctype_loweridx[__temp>>8]*256+(__temp&0x00ff)])

  #define __towupper(a) (__temp=(a),                                   \
                         (unsigned int)__temp < 256                    \
                                      ? __SBUPPER(__temp)              \
                                      : (__temp == WEOF)               \
                                        ? WEOF                         \
                                        : __MBUPPER(__temp))
  #define __towlower(a) (__temp=(a),                                   \
                         (unsigned int)__temp < 256                    \
                                      ? __SBLOWER(__temp)              \
                                      : (__temp == WEOF)               \
                                      ? WEOF                           \
                                      : __MBLOWER(__temp))

   #ifdef __cplusplus
      }
   #endif

#endif

