/****************************************************************************/
/*                                                                          */
/* Sample Program 03 : INITTERM.C                                           */
/*                                                                          */
/* COPYRIGHT:                                                               */
/* ----------                                                               */
/* Copyright (C) International Business Machines Corp., 1991, 1993.         */
/*                                                                          */
/* DISCLAIMER OF WARRANTIES:                                                */
/* -------------------------                                                */
/* The following [enclosed] code is sample code created by IBM              */
/* Corporation.  This sample code is not part of any standard IBM product   */
/* and is provided to you solely for the purpose of assisting you in the    */
/* development of your applications.  The code is provided "AS IS",         */
/* without warranty of any kind.  IBM shall not be liable for any damages   */
/* arising out of your use of the sample code, even if they have been       */
/* advised of the possibility of such damages.                              */
/*                                                                          */
/****************************************************************************/

#include <windows.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#define  CCHMAXPATH  255

/* _CRT_init is the C run-time environment initialization function.         */
/* It will return 0 to indicate success and -1 to indicate failure.         */

int _CRT_init(void);

/* _CRT_term is the C run-time environment termination function.            */

void _CRT_term(void);


size_t _Export nSize;
int * _Export pArray;

/* _DLL_InitTerm is the function that gets called by the operating system   */
/* loader when it loads and frees this DLL for each process that accesses   */
/* this DLL.  However, it only gets called the first time the DLL is loaded */
/* and the last time it is freed for a particular process.  The system      */
/* linkage convention MUST be used because the operating system loader is   */
/* calling this function.                                                   */

unsigned long __stdcall _DLL_InitTerm(unsigned long hModule, unsigned long
                                    ulFlag, long * dummy)
{
   size_t i;
   int  rc;
   char namebuf[CCHMAXPATH];

   /* If ulFlag is DLL_PROCESS_ATTACH then the DLL is being loaded so initialization should*/
   /* be performed.  If ulFlag is DLL_PROCESS_DETACH then the DLL is being freed so       */
   /* termination should be performed.                                      */

   switch (ulFlag) {
      case DLL_PROCESS_ATTACH :

         /*******************************************************************/
         /* The C run-time environment initialization function must be      */
         /* called before any calls to C run-time functions that are not    */
         /* inlined.                                                        */
         /*******************************************************************/

         if (_CRT_init() == -1)
            return 0UL;

         if ((rc = GetModuleFileName((void *)hModule, namebuf, CCHMAXPATH)) == 0)
            printf("GetModuleFileName returned %lu\n", GetLastError());
         else
            printf("The name of this DLL is %s\n", namebuf);
         srand(17);
         nSize = (rand()%128)+32;
         printf("The array size for this process is %u\n", nSize);
         if ((pArray = malloc(nSize *sizeof(int))) == NULL) {
            printf("Could not allocate space for unsorted array.\n");
            return 0UL;
         }
         for (i = 0; i < nSize; ++i)
            pArray[i] = rand();
         break;

      case DLL_PROCESS_DETACH :
         printf("The array will now be freed.\n");
         free(pArray);
         _CRT_term();
         break;

      default  :
         printf("ulFlag = %lu\n", ulFlag);
         return 0UL;
   }

   /* A non-zero value must be returned to indicate success.                */

   return 1UL;
}
